param(
  [switch]$Preview,
  [switch]$Execute,
  [switch]$Strict = $false,
  [string]$Root = "\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets\_registry"
)

function NowIso { (Get-Date).ToString('s') }

if ([string]::IsNullOrWhiteSpace($Root) -or $Root -eq "-Root" -or $Root -like "-*") {
  $Root = "\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets\_registry"
}

$mode  = if($Execute){ "EXECUTE" } else { "PREVIEW" }
$stage = "C:\Temp_Gouvernance"
$wr    = "C:\Temp_Gouvernance\wrappers"
$runner = if($mode -eq "PREVIEW"){ Join-Path $wr "gov_runner_preview.ps1" } else { Join-Path $wr "gov_runner_execute.ps1" }

Write-Host ("== PIPELINE GUARD v1.2.7 :: {0} ==" -f (NowIso))
Write-Host ("Root  : {0}" -f $Root)
Write-Host ("Stage : {0}" -f $stage)
Write-Host ("Mode  : {0}" -f $mode)
Write-Host ("DoIngest=True  AutoFix=True  Strict={0}" -f $Strict)

function RunStep([string]$name, [string[]]$more){
  Write-Host ("-- Step :: {0} :: {1} --" -f $name,(NowIso))
  & $runner $name @more
}

# IMPORTANT :
# Ces 4 scripts confondent '-Root' avec une valeur.
# => On leur passe UNIQUEMENT le chemin en positionnel.
$positional = @($Root)

# 1) BULK INGEST
RunStep "kb_bulk_ingest_v1.3.ps1"        $positional
Write-Host ("[OK] KB mise a jour : {0}" -f (NowIso))

# 2) ASCII SCRUB
RunStep "kb_ascii_scrub_v1.0.ps1"        $positional

# 3) EMIT BOOTPACK DUAL
RunStep "kb_emit_bootpack_dual_v1.1.ps1" $positional

# 4) ACCEPTANCE
RunStep "kb_acceptance_tests_v1.0.1.ps1"   $positional

# 5) QUICKLOG : chemin en positionnel (déjà OK)
RunStep "kb_quicklog_and_sync_v1.3.ps1"  @($Root)

# 6) COMPARE LITE : chemin en positionnel (déjà OK)
RunStep "kb_compare_lite_v1.1.ps1"       @($Root)

Write-Host "[OK] Pipeline guard termine."