# gov_pipeline_interactive_write_v1.0.ps1  (v1.0.3 clean rewrite)
# Preview -> Prompt O/N -> Real write (ingest + emit) + post-hook + acceptance
# PS 5.1-safe, UTF-8 no BOM, CRLF, ASCII-safe

param(
  [string]$Root = '\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets\_registry',
  [switch]$Utf8Console,
  [switch]$NoPrompt
)

if($Utf8Console){ try{ [Console]::OutputEncoding = [Text.Encoding]::UTF8 }catch{} }

$scripts = Join-Path $Root 'scripts'
$inbox   = Join-Path $Root 'updates\inbox\kb'
$emit    = Join-Path $scripts 'kb_emit_bootpack_dual_v1.1.ps1'
$ingest  = Join-Path $scripts 'kb_quicklog_and_sync_v1.2.1.ps1'
$posthk  = Join-Path $scripts 'post_bootpack_pointer_refresh_v1.0.2.ps1'
$accept  = Join-Path $scripts 'kb_acceptance_tests_v1.0.1.ps1'

function Exists([string]$p){ return (-not [string]::IsNullOrWhiteSpace($p)) -and (Test-Path -LiteralPath $p) }
function Run-Tool([string]$path,[string[]]$argv){ $null = & powershell -NoProfile -ExecutionPolicy Bypass -File $path @argv; return [int]$LASTEXITCODE }
function Run-Tool-Write([string]$path,[string[]]$argv){
  try{ $null = & powershell -NoProfile -ExecutionPolicy Bypass -File $path @($argv + '-Execute');       return [int]$LASTEXITCODE }catch{}
  try{ $null = & powershell -NoProfile -ExecutionPolicy Bypass -File $path @($argv + '-Preview:$false'); return [int]$LASTEXITCODE }catch{}
  $null = & powershell -NoProfile -ExecutionPolicy Bypass -File $path @argv; return [int]$LASTEXITCODE
}

function Read-Text-UTF8([string]$p){ if(-not (Test-Path -LiteralPath $p)){ return '' } try{ return Get-Content -LiteralPath $p -Raw -Encoding UTF8 }catch{ return (Get-Content -LiteralPath $p -Raw) } }
function Count-EntriesFromJson-Simple([string]$t){
  if([string]::IsNullOrWhiteSpace($t)){ return -1 }
  if($t.Length -gt 0 -and ([int]$t[0] -eq 0xFEFF)){ $t=$t.Substring(1) }
  try{ $o=$t|ConvertFrom-Json; if($o -and $o.PSObject.Properties.Name -contains 'entries'){ return @($o.entries).Count } }catch{}
  try{ $m=[regex]::Match($t,'(?ms)"entries"\s*:\s*\[(.*?)\]'); if($m.Success){ return ([regex]::Matches($m.Groups[1].Value,'(?i)"id"\s*:')).Count } }catch{}
  return -1
}
function SelfHeal-Pointer([string]$Root){
  $boot = Join-Path $Root 'bootpack\bootpack.txt'
  $paste= Join-Path $Root 'bootpack\bootpack_paste.txt'
  if(-not (Test-Path -LiteralPath $boot) -or -not (Test-Path -LiteralPath $paste)){ return 1 }
  $raw = Read-Text-UTF8 $boot
  $has = [regex]::IsMatch($raw,'(?m)^\[BUG_KB_JSON_POINTER\]\s*$')
  $okPath = $false
  if($has){ $m=[regex]::Match($raw,'(?m)^\s*Path\s*:\s*(.+?)\s*$'); if($m.Success){ $p=$m.Groups[1].Value.Trim(); $okPath=(Test-Path -LiteralPath $p) } }
  if(-not $has -or -not $okPath){
    $sha=(Get-FileHash -Algorithm SHA256 -LiteralPath $paste).Hash.ToUpperInvariant()
    $size=(Get-Item -LiteralPath $paste).Length
    $ent=Count-EntriesFromJson-Simple (Read-Text-UTF8 $paste)
    $blk="[BUG_KB_JSON_POINTER]`r`nPath      : $paste`r`nSHA256    : $sha`r`nEntries   : $ent`r`nSizeBytes : $size`r`n"
    $pat='( ?ms)^\[BUG_KB_JSON_POINTER\].*?(?=^\[|$\Z)'
    $pat = '(?ms)^\[BUG_KB_JSON_POINTER\].*?(?=^\[|$\Z)'
    if([regex]::IsMatch($raw,$pat)){ $new=[regex]::Replace($raw,$pat,$blk) } else { $sep=if($raw -match '\S'){"`r`n`r`n"}else{""}; $new=$raw+$sep+$blk+"`r`n" }
    try{ $enc=New-Object System.Text.UTF8Encoding($false); [IO.File]::WriteAllText($boot, ($new -replace "`r?`n","`r`n"), $enc); Write-Host "[SELF-HEAL] pointer block (re)written." }
    catch{ Write-Host "[SELF-HEAL] write failed: $($_.Exception.Message)"; return 2 }
  }
  return 0
}

Write-Host "== GOV PIPELINE :: INTERACTIVE WRITE v1.0 =="
Write-Host ("Root : {0}" -f $Root)

$countInbox = 0
if(Exists $inbox){ $countInbox = (Get-ChildItem -LiteralPath $inbox -Filter 'AUTO_*.txt' -ErrorAction SilentlyContinue).Count }
Write-Host ("KB inbox  : {0} AUTO_*.txt" -f $countInbox)

Write-Host "BootPack  : PREVIEW plan ->"
if(Exists $emit){ & powershell -NoProfile -ExecutionPolicy Bypass -File $emit $Root } else { Write-Host ("[WARN] emitter not found: {0}" -f $emit) }
Write-Host "----------------------------------------------------------------"

if(-not $NoPrompt){ $resp = Read-Host "Ecrire maintenant ? (O/N)"; if($resp -notmatch '^[OoYy]'){ Write-Host "[ABORT] no write."; exit 0 } }

# -- REAL EXECUTION -----------------------------------------------------
if(($countInbox -gt 0) -and (Exists $ingest)){
  Get-ChildItem -LiteralPath $inbox -Filter 'AUTO_*.txt' | ForEach-Object {
    $f = $_.FullName
    Write-Host ("[INGEST] {0}" -f $f)
    $rc = Run-Tool $ingest @("-FromFile",$f,"-Execute")
    if($rc -ne 0){ Write-Host ("[FAIL] ingest rc={0} : {1}" -f $rc,$f); exit $rc }
  }
} else { Write-Host "[INFO] nothing to ingest (empty inbox or tool missing)." }

if(Exists $emit){
  Write-Host "[EMIT] BootPack (real write)..."
  $rc = Run-Tool-Write $emit @($Root)
  if($rc -ne 0){ Write-Host ("[FAIL] emit rc={0}" -f $rc); exit $rc }
}

Write-Host "[POST] Pointer refresh + acceptance..."
$null = SelfHeal-Pointer $Root
if(Exists $posthk){
  $rc = Run-Tool $posthk @("-Root",$Root,"-NoPrompt","-Verify")
  if($rc -ne 0){
    Write-Host ("[WARN] post-hook rc={0} -> self-heal + retry..." -f $rc)
    $null = SelfHeal-Pointer $Root
    $rc = Run-Tool $posthk @("-Root",$Root,"-NoPrompt","-Verify")
    if($rc -ne 0){ Write-Host ("[FAIL] post-hook rc={0}" -f $rc); exit $rc }
  }
} else { Write-Host ("[WARN] post-hook not found: {0}" -f $posthk) }

if(Exists $accept){
  Write-Host "[CHECK] final acceptance PTR..."
  $rc = Run-Tool $accept @($Root)
  if($rc -ne 0){ Write-Host ("[FAIL] acceptance rc={0}" -f $rc); exit $rc }
}

# -- SUMMARY ------------------------------------------------------------
$left = 0
if(Exists $inbox){ $left = (Get-ChildItem -LiteralPath $inbox -Filter 'AUTO_*.txt' -ErrorAction SilentlyContinue).Count }
Write-Host ("Inbox left : {0}" -f $left)
Get-Item (Join-Path $Root 'bootpack\bootpack_paste.txt'), (Join-Path $Root 'bootpack\bootpack.txt') |
  Select-Object Name, Length, LastWriteTime | Format-Table -AutoSize

Write-Host "[DONE] interactive pipeline applied successfully."
