function Run-PtrRefresh([string]$tool,[string]$root){
  $args = @($root,'-NoPrompt')
  $null = & powershell -NoProfile -ExecutionPolicy Bypass -File $tool @$args
  return [int]$LASTEXITCODE
}
catch{}
  try{ & powershell -NoProfile -ExecutionPolicy Bypass -File $tool $root -Preview:$false; return [int]$LASTEXITCODE }catch{}
  & powershell -NoProfile -ExecutionPolicy Bypass -File $tool $root
  return [int]$LASTEXITCODE
}
# post_bootpack_pointer_refresh_v1.0.2.ps1
# Post-build hook for BootPack: refresh KB pointer + optional acceptance check (PS 5.1 safe)

param(
  [string]$Root = '',
  [switch]$Preview,
  [switch]$NoPrompt,
  [switch]$Verify,
  [switch]$Utf8Console  # optionnel: pour l'affichage correct des accents en console PS 5.1
)

if($Utf8Console){
  try{ [Console]::OutputEncoding = [System.Text.Encoding]::UTF8 }catch{}
}

# --- Robust script path resolution (PS 5.1) ---
# Prefer $PSScriptRoot / $PSCommandPath; fallback to $MyInvocation
$ScriptDir = $null
try{ if($PSScriptRoot){ $ScriptDir = $PSScriptRoot } }catch{}
if([string]::IsNullOrWhiteSpace($ScriptDir)){
  $thisPath = $null
  try{ if($PSCommandPath){ $thisPath = $PSCommandPath } }catch{}
  if([string]::IsNullOrWhiteSpace($thisPath)){ try{ $thisPath = $MyInvocation.MyCommand.Path }catch{} }
  if(-not [string]::IsNullOrWhiteSpace($thisPath)){ try{ $ScriptDir = [System.IO.Path]::GetDirectoryName($thisPath) }catch{} }
}
$DefaultRoot = $null
if(-not [string]::IsNullOrWhiteSpace($ScriptDir)){ try{ $DefaultRoot = [System.IO.Path]::GetDirectoryName($ScriptDir) }catch{} }
if([string]::IsNullOrWhiteSpace($Root)){ $Root = $DefaultRoot }

# Dépendances
$PtrRefresh = $null
$Acceptance = $null
if(-not [string]::IsNullOrWhiteSpace($ScriptDir)){
  try{ $PtrRefresh = Join-Path $ScriptDir 'kb_pointer_refresh_v1.0.ps1' }catch{}
  try{ $Acceptance = Join-Path $ScriptDir 'kb_acceptance_tests_v1.0.1.ps1' }catch{}
}

# Plan (Preview)
$ptrExists = (-not [string]::IsNullOrWhiteSpace($PtrRefresh)) -and (Test-Path -LiteralPath $PtrRefresh)
$accExists = (-not [string]::IsNullOrWhiteSpace($Acceptance)) -and (Test-Path -LiteralPath $Acceptance)

Write-Host '== PLAN :: post_bootpack_pointer_refresh_v1.0.2 =='
Write-Host ("Root         : {0}" -f $Root)
Write-Host ("ScriptDir    : {0}" -f $ScriptDir)
Write-Host ("PtrRefresh   : {0} {1}" -f $PtrRefresh,  $ptrExists)
Write-Host ("Acceptance   : {0} {1}" -f $Acceptance, $accExists)
Write-Host ("Actions      : 1) Refresh KB pointer  2) Verify PTR (optional)")
if($Preview){
  Write-Host '[PREVIEW] Simulation uniquement. Aucune écriture déclenchée par ce hook.'
  exit 0
}
if(-not $NoPrompt){
  $resp = Read-Host 'Exécuter le hook maintenant ? (O/N)'
  if($resp -notmatch '^[OoYy]'){ Write-Host '[ABORT] Hook non exécuté.'; exit 0 }
}

# Guards
if([string]::IsNullOrWhiteSpace($Root) -or -not (Test-Path -LiteralPath $Root)){
  Write-Host '[ERROR] Root introuvable.'; exit 3
}
if(-not $ptrExists){
  Write-Host '[ERROR] kb_pointer_refresh_v1.0.ps1 introuvable.'; exit 3
}

# 1) Refresh pointer + paste
Write-Host '[STEP] Rafraîchissement du KB Pointer...'
$rc = Run-PtrRefresh $PtrRefresh $Root
if($rc1 -ne 0){
  Write-Host ("[FAIL] kb_pointer_refresh_v1.0.ps1 rc={0}" -f $rc1)
  exit $rc1
}
Write-Host '[OK] Pointer rafraîchi.'

# 2) Acceptance (optionnel)
if($Verify){
  if(-not $accExists){
    Write-Host '[WARN] Test d’acceptance absent, skip vérification.'
  } else {
    Write-Host '[STEP] Vérification acceptance PTR...'
    & powershell -NoProfile -ExecutionPolicy Bypass -File $Acceptance $Root
    $rc2 = $LASTEXITCODE
    if($rc2 -ne 0){
      Write-Host ("[FAIL] Acceptance PTR rc={0}" -f $rc2)
      exit $rc2
    }
    Write-Host '[OK] Acceptance PTR PASS.'
  }
}

Write-Host '[OK] post_bootpack_pointer_refresh_v1.0.2 exécuté avec succès.'
# DOC-VERSION-FOOTER: post_bootpack_pointer_refresh_v1.0.2.ps1 | Enc=UTF8-noBOM CRLF | _MAJ_=2025-10-22T19:05:00+02:00