Param(
  [ValidateSet("HUB","SEEDBOX")] [string]$Project = "HUB",
  [switch]$Write
)

try { [Console]::OutputEncoding = New-Object System.Text.UTF8Encoding } catch {}

# Resolve $root (env var -> script folders -> UNC fallback)
$root = $env:GOV_REGISTRY_ROOT
if(-not $root -or -not (Test-Path $root)){
  $root = $null
  if($PSScriptRoot){ $root = Split-Path -Parent $PSScriptRoot }
  if(-not $root -and $MyInvocation -and $MyInvocation.MyCommand -and $MyInvocation.MyCommand.Path){
    $root = Split-Path -Parent (Split-Path -Parent $MyInvocation.MyCommand.Path)
  }
  if(-not $root){ $root = "\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets\_registry" }
}

$profiles = Join-Path $root "profiles\project"
if($Project -eq "HUB"){     $dir = Join-Path $profiles "HUB";     $name="HUB_LYON_LUMIERE_ANALYSE_PROD" }
if($Project -eq "SEEDBOX"){ $dir = Join-Path $profiles "SEEDBOX"; $name="SEEDBOX_MANAGER" }
$target = Join-Path $dir "PROJECT_PROFILE.txt"
$now    = Get-Date -Format "yyyy-MM-ddTHH:mm:ssK"

# TXT-ONLY content (CRLF, UTF-8 no BOM)
$lines = @()
$lines += "=== PROJECT PROFILE ==="
$lines += ("Name: {0}" -f $name)
$lines += ("Scope: {0}" -f $Project)
if($Project -eq "HUB"){
  $lines += "Encoding: PS1=UTF-8 (no BOM); CMD=ASCII CRLF; SH=ASCII LF; TXT=UTF-8 (no BOM)"
  $lines += "Env: PowerShell=5.1; Excel=365 Desktop (no macro); Admin=No; OneDrive=Pro (separe)"
}
if($Project -eq "SEEDBOX"){
  $lines += "Encoding: PS1 annexes Windows=UTF-8 (BOM); SH=/bin/sh (ASCII-only, LF); TXT=UTF-8 (no BOM)"
  $lines += "Env: Shell=/bin/sh; POSIX strict; No here-strings; Annexes .ps1 Windows in UTF-8 BOM"
}
$lines += ("Created: {0}" -f $now)
$lines += "Writer: write_project_profile_v1.0"

function Write-Text([string]$path,[string[]]$content){
  $text = [string]::Join("`r`n",$content) + "`r`n"
  $enc  = New-Object System.Text.UTF8Encoding($false) # no BOM
  $parent = Split-Path -Parent $path
  if(-not (Test-Path $parent)){ New-Item -ItemType Directory -Force -Path $parent | Out-Null }
  if(Test-Path $path){
    $bak = $path + ".bak_" + (Get-Date -Format "yyyyMMdd_HHmmss")
    Copy-Item -LiteralPath $path -Destination $bak -Force
  }
  [IO.File]::WriteAllText($path,$text,$enc)
}

Write-Host "== PROJECT PROFILE WRITER =="
Write-Host ("Project : {0}" -f $Project)
Write-Host ("Target  : {0}" -f $target)

if($Write){
  Write-Text -path $target -content $lines
  $sha = (Get-FileHash -Algorithm SHA256 -LiteralPath $target).Hash
  Write-Host ("STATUS  : WRITE-OK (SHA={0})" -f $sha)
  Write-Host "NEXT    : rebuild BootPack to inject PROFILE_SHA256, then verify MANIFEST_SHA256."
}else{
  Write-Host "Mode    : PREVIEW (no write)"
  $max=[Math]::Min($lines.Count,10)-1
  if($max -ge 0){
    Write-Host "----- PREVIEW (first 10 lines) -----"
    0..$max | ForEach-Object { Write-Host $lines[$_] }
    Write-Host "------------------------------------"
  }
}