# ============================================================
# Script : run_encoding_maintenance.ps1
# Objet  : Lance verification + correction + re-verification
# Auteur : ChatGPT - GPT-5
# Date   : 11/10/2025
# ============================================================

\\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets = "\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets"
\ = Join-Path \\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets "00_DOCUMENTATION\scripts_utilitaires"
\ = Join-Path \ "verify_encoding_gouvernance_fixed.ps1"
\    = Join-Path \ "fix_encoding_gouvernance_fixed.ps1"
\ = Join-Path \\\DS-918\chatgpt\ChatGPT-Gouvernance-Projets "_registry\ENCODING_REPORT.txt"
\11-10-2025 20:50 = Get-Date -Format "dd-MM-yyyy HH:mm"

Write-Host "============================================" -ForegroundColor Cyan
Write-Host "[RUN] Maintenance d'encodage - \11-10-2025 20:50" -ForegroundColor Cyan
Write-Host "============================================
"

function Run-Script(\, \) {
    if (Test-Path \) {
        Write-Host "[INFO] Execution de \ ..." -ForegroundColor Yellow
        & \
        Write-Host ""
    } else {
        Write-Host "[ERREUR] Script manquant : \" -ForegroundColor Red
        exit 1
    }
}

# Etape 1 : Verification initiale
Run-Script \ "Verification initiale"

# Lecture du rapport
\ = \False
if (Test-Path \) {
    \ = Get-Content -Path \ -Raw -Encoding UTF8
    if (\ -match "AccentsDetectes=OUI" -or \ -match "UTF-16" -or \ -match "BOM") {
        \ = \True
        Write-Host "[ALERTE] Anomalies detectees dans les fichiers." -ForegroundColor Yellow
    } else {
        Write-Host "[CHECK] Aucun probleme d'encodage detecte." -ForegroundColor Green
    }
} else {
    Write-Host "[WARN] Rapport introuvable apres verification initiale." -ForegroundColor Yellow
}

# Etape 2 : Correction si necessaire
if (\) {
    Run-Script \ "Correction automatique"
} else {
    Write-Host "[INFO] Etape de correction sautee (aucune anomalie)." -ForegroundColor Cyan
}

# Etape 3 : Re-verification
Run-Script \ "Re-verification finale"

# Etape 4 : Affichage du resultat
if (Test-Path \) {
    Write-Host "
[OK] Rapport final : \" -ForegroundColor Green
    Start-Process notepad.exe \
} else {
    Write-Host "[WARN] Aucun rapport de verification final trouve." -ForegroundColor Yellow
}

Write-Host "
[END] Maintenance complete." -ForegroundColor Cyan