# SYNOMAP_V2_A0_MASTER_SPEC.txt

```
SYNOMAP_V2_A0_MASTER_SPEC — VERSION FINALE
==========================================

Document : SYNOMAP V2 — BRANCHE A0 (TORRENT NON FINALISÉ)
Statut : Verrouillé (ChatGPT + Gemini)
Portée : États, familles, invariants, transitions, matrice d’actions, règles de sécurité.

------------------------------------------------------------
1. OBJECTIF DU DOCUMENT
------------------------------------------------------------

Ce document définit la totalité de la logique Synomap V2 pour la branche A0, c’est‑à‑dire tous les états possibles lorsqu’un torrent :

- n’est pas finalisé par le client (A0),
- est en cours de téléchargement, en pause, en file d’attente, en checking ou stalled,
- n’a pas encore été promu en « completed / seeding » (A2),
- n’est pas en état d’erreur bloquante (A1).

La branche A1 (TORRENT_ERROR) et la branche A2 (COMPLETED_FROM_EXISTING_DATA) sont définies dans d’autres documents. Ici, on se concentre sur tout ce qui se passe tant que le torrent reste en A0.

Ce document sert de référence fonctionnelle et technique (« master spec ») pour :

- la conception de Synomap V2,
- la validation des comportements avec Sonarr / Radarr / qBittorrent,
- la sécurisation contre toute perte de données accidentelle.


------------------------------------------------------------
2. AXES STRUCTURANTS (A / B / C)
------------------------------------------------------------

L’état complet d’un « torrent + environnement Synomap » est défini par trois axes orthogonaux :

2.1 Axe A — État du torrent dans le client

- A0 : torrent non finalisé (downloading, paused, queued, checking DL…).
- A1 : torrent en erreur (TORRENT_ERROR, I/O error, missing files, etc.).
- A2 : torrent complété / seeding (COMPLETED_FROM_EXISTING_DATA ou équivalent).

La présente spec couvre uniquement la branche A0, mais doit être cohérente avec les transitions vers A1 et A2.

2.2 Axe B — Résolution du mapping (source → destination)

B décrit la capacité de Synomap à relier un torrent (hash, nom, tags…) à un chemin destination sur le Synology :

- B0 : aucun mapping connu.
- B1 : mapping clair et direct (table, JSONL, règle unique).
- B2 : mapping clair mais obtenu via heuristique (fallback).
- B3 : mapping clair multi‑règles, mais qui converge vers un chemin unique.
- B4 : mapping ambigu (plusieurs chemins candidats, contradictions non résolues).

2.3 Axe C — État du répertoire destination (Côté Synology)

C décrit l’état logique des fichiers présents dans le répertoire ciblé par le mapping :

- C0 : destination neutre / vide pour ce torrent.
- C1 : destination partielle mais cohérente avec le payload attendu.
- C2 : destination complète et cohérente (tous les « Main Assets » attendus sont présents et intègres).
- C3 : corruption (au moins un Main Asset est illisible, tronqué, hash mismatch, I/O error…).
- C4 : collision logique (les fichiers présents sont valides en eux‑mêmes, mais ne correspondent pas au payload attendu pour ce torrent : mauvaise release, mauvaise saison, autre structure, autre torrent…).

2.4 Réduction combinatoire

Théoriquement, A0 × (B0…B4) × (C0…C4) = 25 combinaisons pour la branche A0.

Mais :
- si B0 (aucun mapping), Synomap ne connaît aucun chemin destination,
- donc il lui est impossible d’observer C1/C2/C3/C4,
- les combinaisons A0/B0/C1–C4 sont physiquement possibles mais **non observables par l’automate**.

On les marque comme « hors modèle » et on ne garde dans l’automate que :
- A0/B0/C0,
- plus toutes les combinaisons A0/Bx/Cy avec x ∈ {1,2,3,4} et y ∈ {0,1,2,3,4}.

On aboutit à 21 états observables regroupés en 11 familles fonctionnelles (F0 à F10).


------------------------------------------------------------
3. LES 11 FAMILLES A0 (F0 → F10)
------------------------------------------------------------

Chaque famille F? regroupe un sous‑ensemble d’états A0/B?/C? que Synomap traitera « de la même façon », avec des règles d’action et de sécurité identiques.

Notation :
- A est toujours A0 dans ce document.
- On ne détaille que (B,C) pour décrire les familles.

------------------------------------------------------------
3.1 F0 — A0 / B0 / C0 — « AVEUGLE / SAFE MODE »
------------------------------------------------------------

Définition :
- Aucun mapping connu (B0).
- Destination non observable (C forcé à C0 du point de vue Synomap).

Interprétation :
- Synomap ne sait pas *où* regarder.
- Il ne peut rien affirmer sur l’état réel du disque.

Règle majeure F0‑S1 (sécurité) :
- En F0, **toute action destructive ou de redownload automatique est interdite**.

Conséquences :
- Pas de purge (aucune suppression de fichier).
- Pas d’overwrite / écriture sur une destination inconnue.
- Pas de redownload massif déclenché par « état inconnu ».
- Autorisé : observation côté client, mise à jour de tags, attente d’un mapping.

F0 joue le rôle de « Safe Mode aveugle ».


------------------------------------------------------------
3.2 F1 — A0 / B1–B3 / C0 — « NEUTRE / VIDE »
------------------------------------------------------------

Définition :
- Mapping résoluble et unique (B1, B2 ou B3).
- Destination neutre (aucun Main Asset présent pour ce torrent).

Interprétation :
- Le système sait où il devrait écrire.
- Le répertoire cible est considéré comme vide pour le payload de ce torrent.

Actions autorisées (concept) :
- Téléchargement normal vers C.
- Création de fichiers (écriture) cohérente avec le payload.
- Hash‑check destination une fois les fichiers écrits.

Actions interdites :
- Purge globale de C sans lien avec ce torrent (mais en pratique, C est vide pour ce torrent).

F1 est le cas « propre » : terrain vierge, prêt pour une écriture.


------------------------------------------------------------
3.3 F2 — A0 / B4 / C0 — « AMBIGU / NEUTRE »
------------------------------------------------------------

Définition :
- Mapping ambigu (B4).
- Destination neutre (aucun Main Asset explicitement identifié).

Interprétation :
- Synomap ne sait pas de façon certaine *quel* chemin utiliser.
- Tant que cette ambiguïté n’est pas levée, aucune action automatique sur C n’est sûre.

Actions :
- Aucune écriture sur C tant que B4 n’est pas résolu.
- Autorisé : ajustement / correction du mapping, mise à jour de la config.

F2 est un état de blocage logique dû exclusivement au mapping.


------------------------------------------------------------
3.4 F3 — A0 / B1–B3 / C1 — « PARTIEL / COHÉRENT »
------------------------------------------------------------

Définition :
- Mapping résoluble (B1–B3).
- Destination partiellement peuplée avec des Main Assets cohérents (C1).

Interprétation :
- Certains fichiers du payload sont déjà présents et sains.
- D’autres manquent encore.

Actions :
- Téléchargement des blocs/fichiers manquants.
- Reconstruction / complétion de C à partir du client.
- Purge ciblée possible pour des fichiers clairement étrangers à ce torrent.
- Pas de purge globale du répertoire.

F3 est un état « normal » de progression : on peut atteindre F5 (complet) ou dériver vers F7 / F9 si anomalies.


------------------------------------------------------------
3.5 F4 — A0 / B4 / C1 — « PARTIEL / AMBIGU »
------------------------------------------------------------

Définition :
- Mapping ambigu (B4).
- Destination partiellement peuplée (C1).

Interprétation :
- Synomap voit des fichiers, mais ne sait pas de façon certaine s’ils appartiennent à ce torrent ou à un autre.
- Risque élevé de toucher des données d’un autre torrent ou d’une autre release.

Actions :
- Aucune écriture.
- Aucune purge automatique.
- Actions limitées à : correction manuelle du mapping, attente.

F4 est un état de blocage prudent : on ne sait pas suffisamment pour agir.


------------------------------------------------------------
3.6 F5 — A0 / B1–B3 / C2 — « CROSS‑SEED CLAIR (C2) »
------------------------------------------------------------

Définition :
- Torrent non finalisé (A0).
- Mapping résoluble et unique (B1–B3).
- Destination en C2, avec la définition suivante :

Invariant F5‑I3 (C2 Main Assets) :
- **Tous les Main Assets attendus par le torrent sont présents et intègres dans le répertoire destination.**
- Les fichiers « extra » (NFO, JPG, samples, résidus Sonarr/Radarr, etc.) sont tolérés :
  - ils ne remettent pas en cause C2,
  - C2 porte uniquement sur la complétude et l’intégrité des Main Assets.

Autres invariants :
- F5‑I1 : côté client, le torrent reste dans A0 (pas encore completed).
- F5‑I2 : mapping résoluble, pas de B4.
- F5‑I4 : aucun fichier Main Asset en corruption (C3) ni en collision (C4).
- F5‑I5 : la destination est considérée comme la **Source of Truth** pour ce torrent.
- F5‑I6 : aucune action F5 ne doit détruire des données valides.

Transition de succès (F5‑T1) :
- Hash‑check côté client sur les fichiers déjà présents.
- Si tout est valide : transition A0 → A2, on fixe :

  - **A2 = TORRENT_COMPLETED_FROM_EXISTING_DATA**  
    (torrent complété à partir des données déjà présentes).

- La classe B reste B1–B3, C reste C2.

Transitions d’échec possibles :
- F5 → F7 si la vérification révèle une corruption (C2→C3).
- F5 → F9 si la vérification révèle une collision logique (C2→C4).
- F5 → F6 si le mapping devient ambigu (B→B4).
- F5 → F0 si le mapping disparaît (B→B0), avec application de F0‑S1.

Actions autorisées :
- Hash‑check côté client.
- Promotion vers A2 après hash‑check réussi.

Actions interdites :
- Toute écriture sur C.
- Tout redownload depuis le swarm (si cela s’impose, on n’est plus en F5).

F5 est la famille « Cross‑seed propre » : succès idéal.


------------------------------------------------------------
3.7 F6 — A0 / B4 / C2 — « CROSS‑SEED AMBIGU »
------------------------------------------------------------

Définition :
- Destination complète (C2).
- Mapping ambigu (B4).

Interprétation :
- Le répertoire contient un payload complet, mais Synomap n’est pas sûr qu’il corresponde *à ce torrent précis*.
- Risque élevé d’associer un torrent aux mauvais fichiers.

Actions :
- Aucune écriture sur C.
- Aucune promotion vers A2.
- Seule issue sûre : résolution du mapping (B4→B1–B3) permettant un reclassement en F5, F7 ou F9 selon les contrôles.


------------------------------------------------------------
3.8 F7 — A0 / B1–B3 / C3 — « CORRUPTION (DESTINATION NON SoT) »
------------------------------------------------------------

Définition :
- Mapping résoluble (B1–B3).
- Au moins un Main Asset en C3 = corruption :
  - illisible,
  - hash mismatch,
  - tronqué,
  - I/O error.

Invariants :
- F7‑I1 : torrent non finalisé (A0).
- F7‑I2 : mapping unique et stable (B1–B3).
- F7‑I3 : au moins un Main Asset cassé.
- F7‑I4 : on ne requalifie en collision (C4) que si les fichiers sont valides mais incohérents (autre cas).
- F7‑I5 : la destination **n’est plus** SoT pour ce torrent.
- F7‑I6 : les Main Assets sains ne doivent pas être détruits aveuglément.

Stratégie de réparation F7‑A1 (définitive) :
1) Hash‑check côté client (source B) :
   - Si la source (chemin download du client) est saine :
     - la corruption vient du transfert ou d’un problème côté C ;
     - la réparation consiste à recréer C à partir de B (recopie / re‑hardlink).
   - Si la source est corrompue :
     - la réparation implique un re‑téléchargement complet ou partiel depuis le swarm ;
     - une fois B restaurée, C est reconstruit depuis B.

2) Interdiction d’utiliser C pour réparer B :
   - C est explicitement marqué « Non SoT » en F7.

Transitions principales :
- F7 → F5 : réparation réussie, C3→C2 (cross‑seed possible).
- F7 → A2 : si la réparation inclut un hash‑check client complet qui valide le torrent.
- F7 → F3 ou F1 : si la réparation passe par une purge partielle ou totale des Main Assets de ce torrent.
- F7 → F9 : si, en analysant C, on découvre une collision logique (C4).
- F7 → A1 : si la réparation échoue de manière répétée ou permanente.

F7 est la famille « Corruption détectée » : flux de réparation obligatoire, priorité élevée.


------------------------------------------------------------
3.9 F8 — A0 / B4 / C3 — « CORRUPTION + MAPPING AMBIGU »
------------------------------------------------------------

Définition :
- Mapping ambigu (B4).
- Destination avec corruption (C3).

Interprétation :
- Double problème : on ne sait pas précisément quelle structure logique appliquer (B4), alors même que les fichiers sont en partie corrompus (C3).

Actions :
- Aucune écriture sur C.
- Pas de purge automatique.
- Seules évolutions sûres :
  - F8 → F7 si le mapping est clarifié (B4→B1–B3),
  - F8 → F10 si la situation se dégrade en collision.

F8 est un état de blocage « multi‑défaillances ».


------------------------------------------------------------
3.10 F9 — A0 / B1–B3 / C4 — « COLLISION LOGIQUE »
------------------------------------------------------------

Définition :
- Mapping résoluble (B1–B3).
- Destination en C4 = collision logique :
  - fichiers valides mais appartenant à une autre release, une autre saison, un autre torrent, etc.

Exemples :
- Torrent attendu = S03E01 release NTb, destination contient S01E05 EVO.
- Torrent attendu = MKV unique, destination contient plusieurs MP4 d’une autre structure.
- Dossier complet présent, mais manifestement celui d’un autre torrent.

Invariants :
- F9‑I1 : A0 (non finalisé).
- F9‑I2 : mapping résoluble.
- F9‑I3 : les fichiers présents sont valides pour *eux‑mêmes*, mais pas pour ce torrent.
- F9‑I4 : F9 n’est **pas** une corruption ; hormis la logique, les fichiers ne sont pas cassés.
- F9‑I5 : la destination n’est SoT pour rien concernant ce torrent, mais peut l’être pour autre chose.
- F9‑I6 : le client torrent ne sait pas distinguer NTb/EVO, S01/S03, etc. Il ne peut pas résoudre F9 seul.

Règles de sécurité :

F9‑A1 — Interdiction d’écrasement automatique :
- Tant que la collision n’est pas explicitement levée, aucune écriture sur C (overwrite, rename, création de nouveaux fichiers) n’est autorisée.
- Aucun « rm ‑rf » du répertoire n’est autorisé par défaut.

F9‑A2 — Interdiction d’utiliser C pour réparer B :
- Contrairement à F7, ici C n’est même pas une « version cassée du bon fichier » : ce sont les *mauvais* fichiers.
- Le client torrent doit ignorer C pour toute logique de réparation.

F9‑A3 — Purge ciblée éventuellement possible, mais jamais automatique :
- Purge possible uniquement si les fichiers sont identifiés de façon certaine comme appartenant à un autre torrent et si une politique explicite l’autorise.
- Par défaut, aucune purge automatique.

F9‑A4 — Reconstruction C depuis B :
- Possible seulement **après** levée de la collision (déplacement/rename/purge manuelle des fichiers conflictuels).
- Tant que C4 est vrai, aucune reconstruction (RC) n’est autorisée.

Transitions :

- F9 → F5/F3/F1 après résolution de la collision et reconstruction contrôlée de C.
- F9 → F7 si certains fichiers deviennent corrompus (C4→C3).
- F9 → F10 si le mapping devient ambigu (B→B4).

F9 est la famille la plus dangereuse pour les données : on protège tout par le principe de moindre surprise.


------------------------------------------------------------
3.11 F10 — A0 / B4 / C4 — « COLLISION + MAPPING AMBIGU »
------------------------------------------------------------

Définition :
- Mapping ambigu (B4).
- Collision logique (C4).

Interprétation :
- On ne sait ni précisément *où* on devrait être (B4), ni *ce que* représentent les fichiers présents (C4).
- État indécidable et bloqué.

Actions :
- Aucune écriture.
- Pas de purge automatique.
- Pas de reconstruction.
- Seule issue saine : intervention externe (admin) pour nettoyer et/ou corriger le mapping.


------------------------------------------------------------
4. TRANSITIONS GLOBALES A0
------------------------------------------------------------

Ce tableau liste les transitions autorisées entre familles F0–F10, sans détailler chaque micro‑événement (déjà décrit dans les sections F5/F7/F9).

- F0 → F1 / F3 / F5 / F7 / F9 / F10  
  (lorsqu’un mapping fiable apparaît et que C est observé).

- F1 → F3 / F5 / F7 / F9  
  (destination qui se remplit partiellement, complètement, ou révèle corruption/collision).

- F2 → F1 / F10  
  (résolution du mapping → F1, ou prise de conscience d’une collision ambiguë → F10).

- F3 → F5 / F7 / F9  
  (complétion → F5, corruption détectée → F7, collision détectée → F9).

- F4 → F3 / F10  
  (résolution B4 → B1–B3 → C1 cohérent → F3, ou collision + ambigu → F10).

- F5 → A2 / F7 / F9 / F6 / F0  
  (succès cross‑seed → A2, corruption → F7, collision → F9, ambiguïté mapping → F6, perte de mapping → F0).

- F6 → F5 / F10 / F7  
  (levée de l’ambiguïté vers F5, dégénérescence en collision ou corruption).

- F7 → F5 / F3 / F1 / F9 / A1 / A2  
  (réparation → F5 ou F3 ou F1, découverte de collision → F9, échec définitif → A1, réussite finale complète → A2).

- F8 → F7 / F10  
  (clarification mapping → F7, aggravation collision+corruption → F10).

- F9 → F5 / F3 / F1 / F7 / F10  
  (après nettoyage + reconstruction → états cohérents, découverte corruption → F7, mapping devient ambigu → F10).

- F10 → F9 / F8  
  (clarification partielle ou évolution des symptômes).

Ces transitions sont cohérentes avec la matrice d’actions (section 5) et les règles de sécurité (section 6).


------------------------------------------------------------
5. MATRICE BINAIRE V2 — CASE × ACTIONS
------------------------------------------------------------

Actions standardisées :

- PC  = Purge ciblée (suppression d’éléments explicitement identifiés comme non pertinents pour ce torrent).
- PG  = Purge globale (effacement du répertoire ou de toutes les données du torrent).
- WR  = Write / Overwrite sur C (création ou écriture de fichiers pour ce torrent).
- RC  = Reconstruction de C à partir de B (source client).
- A2  = Promotion vers A2 (torrent completed/seeding).
- RD  = Redownload depuis le swarm (récupération de données manquantes/cassées).
- HC  = Hash‑check côté client (sur le chemin de données du client).
- HC_C= Hash‑check côté destination (directement sur C).
- MAP = Modification du mapping (édition des règles/JSONL).
- WAIT= Aucune action, attente, surveillance.

Symboles :
- ✓ : autorisé.
- X : interdit.
- ! : autorisé sous forte condition (politique explicite).
- ~ : autorisé uniquement après résolution d’un blocage préalable (collision levée, etc.).

Matrice :

Case / Actions  | PC | PG | WR | RC | A2 | RD | HC | HC_C | MAP | WAIT
----------------|----|----|----|----|-----|-----|-----|------|-----|------
F0 (A0/B0/C0)   | X  | X  | X  | X  | X  | X  | ✓  | X    | ✓   | ✓
F1 (B1–3/C0)    | X  | X  | ✓  | ✓  | X  | ✓  | ✓  | ✓    | ✓   | ✓
F2 (B4/C0)      | X  | X  | X  | X  | X  | ✓  | ✓  | X    | ✓   | ✓
F3 (B1–3/C1)    | ✓  | X  | ✓  | ✓  | X  | ✓  | ✓  | ✓    | ✓   | ✓
F4 (B4/C1)      | X  | X  | X  | X  | X  | ✓  | ✓  | X    | ✓   | ✓
F5 (B1–3/C2)    | X  | X  | X  | X  | ✓  | X  | ✓  | ✓    | ✓   | ✓
F6 (B4/C2)      | X  | X  | X  | X  | X  | X  | ✓  | X    | ✓   | ✓
F7 (B1–3/C3)    | ✓  | !  | ~  | ✓  | ~  | ✓  | ✓  | X    | ✓   | ✓
F8 (B4/C3)      | X  | X  | X  | X  | X  | ✓  | ✓  | X    | ✓   | ✓
F9 (B1–3/C4)    | !  | X  | X  | ~  | X  | ✓  | ✓  | X    | ✓   | ✓
F10 (B4/C4)     | X  | X  | X  | X  | X  | ✓  | ✓  | X    | ✓   | ✓

Commentaire synthétique :

- F0 : Safe Mode, aucune action sur C, seulement HC côté client et MAP.
- F1 : cas standard de download, écriture autorisée.
- F3 : cas partiel, écriture et purge ciblée autorisées.
- F5 : état parfait, seule action significative = promotion A2 (pas de RD, pas de RC).
- F7 : état de corruption, autorise réparation, purge ciblée, RD, mais pas de purge globale par défaut.
- F9 : collision logique, purge seulement sous politique explicite, reconstruction possible seulement après levée de collision.


------------------------------------------------------------
6. RÈGLES DE SÉCURITÉ TRANSVERSES
------------------------------------------------------------

6.1 F0‑S1 — Safe Mode aveugle
- Tant que B0, Synomap :
  - ne purge rien,
  - ne télécharge pas vers C,
  - ne considère jamais C comme vide ou safe.
- Seules actions permises : HC côté client, MAP, WAIT.

6.2 F9‑A1 — Protection des données en collision
- Tant que C4 (collision logique), Synomap :
  - n’écrase jamais de fichiers,
  - ne purge jamais automatiquement un répertoire,
  - ne reconstruit pas C tant que la collision n’est pas levée par une action explicite.

6.3 Priorité des sources (B > C)
- En F7 et F9, la logique de réparation / reconstruction passe toujours par :
  - validation / restauration côté client (B),
  - puis reconstruction de C depuis B,
  - jamais l’inverse.

6.4 Promotion A2
- A2 ne peut être atteint qu’à partir de :
  - F5 (Cross‑seed clair, hash‑check client OK),
  - ou F7 (après réparation complète et validation client).
- Aucune autre famille F? ne peut promouvoir directement en A2.


------------------------------------------------------------
7. ISSUES FINALES POUR A0
------------------------------------------------------------

A2 (Succès) :
- F5 → A2 (Cross‑seed réussi).
- F7 → A2 (réparation complète, hash‑check OK).

A1 (Erreur) :
- F7 → A1 (échec définitif de réparation).
- Plus généralement, n’importe quel F? peut être supplanté par un événement A1 émis par le client (I/O error, missing files…) indépendamment de Synomap.

Les autres familles (F0, F1, F2, F3, F4, F6, F8, F9, F10) sont des états intermédiaires ou bloquants, qui doivent conduire à A2 ou A1 par les transitions définies.


------------------------------------------------------------
8. CONCLUSION
------------------------------------------------------------

Cette MASTER SPEC A0 pour Synomap V2 :

- couvre exhaustivement 11 familles d’états (F0 à F10),
- garantit la sécurité des données via des règles de non‑destruction strictes,
- rend explicites les invariants et transitions cruciales (F5 Cross‑seed, F7 Corruption, F9 Collision),
- fournit une matrice binaire d’actions exploitable directement par les développeurs,
- est validée par double audit (ChatGPT Architecte + Gemini QC).

La branche A0 est officiellement **VERROUILLÉE** et peut servir de base à :
- la mise à jour des scripts Synomap V2,
- la documentation globale du projet Seedbox Manager,
- la préparation des branches A1 (erreurs) et A2 (succès), dans le même esprit de rigueur.

```