# Synomap V2 — Documentation des spécifications

Ce dossier contient la **spécification fonctionnelle et technique complète** de Synomap V2, utilisée par les outils Seedmover / Synomap / Checker.

L’objectif de cette documentation est double :
1. Servir de **référence unique** pour les décisions de conception et d’implémentation.
2. Fournir un **cadre de tests fonctionnels** avant tout développement ou refactor.

---

## 1. Arborescence logique

Organisation recommandée :

```text
docs/
└── synomap/
    └── v2/
        ├── SYNOMAP_V2_README_docs.md
        ├── 00_INDEX_Synomap.md
        └── specs/
            ├── SYNOMAP_V2_A0_MASTER_SPEC.md
            ├── SYNOMAP_V2_A1_BRANCH_COMPLETE.md
            ├── SYNOMAP_V2_A2_BRANCH_COMPLETE.md
            ├── SYNOMAP_V2_A3_CASEBOOK.md
            ├── synomap_A4_schema_digest.md
            ├── synomap_checker_spec_v1_digest.md
            ├── synomap_DOC_OV1_metier.md
            ├── synomap_B1_loop_exec_digest.md
            ├── synomap_B2_loop_runner_digest.md
            ├── synomap_B3_correction_digest.md
            ├── synomap_B4_execution_digest.md
            ├── synomap_A2_digest.md
            └── synomap_A3_digest.md
```

---

## 2. Vue d’ensemble des documents A0–A4

### **A0 — MASTER SPEC (Cycle principal)**
**Fichier :** `SYNOMAP_V2_A0_MASTER_SPEC.md`  
Décrit l’automate A0 (F0–F10), les invariants de mapping, la logique de non-destruction, et la philosophie générale.

---

### **A1 — Branche Erreur (TORRENT_ERROR)**
**Fichier :** `SYNOMAP_V2_A1_BRANCH_COMPLETE.md`  
Spécifie l’état A1, les scénarios TORRENT_ERROR, les transitions autorisées et interdites, et la logique de retour vers A0.

---

### **A2 — Branche Succès (TORRENT_SUCCESS)**
**Fichier :** `SYNOMAP_V2_A2_BRANCH_COMPLETE.md`  
Définit les sous-rôles A2 (SeedDirect, CrossSeed, Repaired), les invariants I1–I10, les portes d’entrée, les règles de sortie (A2-EXIT), et la matrice A2/B/C.

---

### **A3 — Case Book Étendu**
**Fichier :** `SYNOMAP_V2_A3_CASEBOOK.md`  
Jeu de tests fonctionnels structuré (BUT, INPUT, TRAJECTOIRE, INVARIANTS, EXPECT), couvrant les scénarios critiques et nominaux.

---

### **A4 — Schéma JSON (Checker Output Format v7)**
**Fichier :** `synomap_A4_schema_digest.md`  
Structure JSON de sortie du Checker : états, issues, invariants, auto-fixes.

---

## 3. DOC_OV1 — Statut global & issues

Deux documents :

- `synomap_checker_spec_v1_digest.md` (vision technique)
- `synomap_DOC_OV1_metier.md` (vision métier)

Ils définissent le calcul d’`overall_status` et l’interaction des blocs E/G/ABC/D/H/HASH.

---

## 4. Série B — Modèles d'exécution (B1 → B4)

- `synomap_B1_loop_exec_digest.md`  
- `synomap_B2_loop_runner_digest.md`  
- `synomap_B3_correction_digest.md`  
- `synomap_B4_execution_digest.md`  

Ils décrivent le fonctionnement réel du moteur Synomap : analyse, planning, corrections, exécution.

---

## 5. 00_INDEX_Synomap.md — Index maître

Contient : ID, fichier, rôle, statut (ACTIVE/FROZEN), version, chemins.  
Source-of-truth référentiel.

---

## 6. Convention de format

- Format canonique : **Markdown (.md)**  
- `.txt` et `.md` ayant le même nom : `.md` = version de référence (règle temporaire).  
- Préfixe V2 pour les documents majeurs (A0–A3).

---

## 7. Usage recommandé

1. Lire A0 pour comprendre l’automate.  
2. Lire A1/A2 pour les transitions.  
3. Lire DOC_OV1 pour comprendre `overall_status`.  
4. Lire B1–B4 pour savoir comment le moteur applique tout ça.  
5. Lire A3 (CaseBook) avant toute implémentation ou refactor.  
6. Lire A4 pour valider les structures JSON.

---
