# SYNOMAP – A4 JSON SCHEMA SPEC v1 (DIGEST – MODE SOUPLE)

SCOPE
-----
Ce document décrit le schéma JSON de la sortie du Checker Synomap v1
(un enregistrement `torrent_record`), en assemblant STRICTEMENT :

- Synomap Checker Spec v1 (A1),
- Ordre d’évaluation (A2),
- Case Book v1 (A3),
- Checker Output Format v7,
- DOC_OV1 (overall_status).

Aucun champ nouveau n’est introduit.
MODE = SOUPLE : des propriétés additionnelles sont autorisées dans les objets.

ROOT
----
Type       : object
Required   : identity, paths, state, diagnostic
Properties :
  identity  : object
  paths     : object
  state     : object
  diagnostic: object
additionalProperties: true

--------------------------------------------------------------------
IDENTITY
--------------------------------------------------------------------
identity: object
  properties:
    torrent_id  : string
    infohash    : string
    name        : string
    category    : string
    mapping_key : string
    size        : integer (>=0)
  required:
    torrent_id, infohash, name, category, mapping_key, size
  additionalProperties: true

--------------------------------------------------------------------
PATHS
--------------------------------------------------------------------
paths: object
  properties:
    src_root   : string
    dst_root   : string
    plex_paths : array of string
  required:
    src_root, dst_root, plex_paths
  additionalProperties: true

--------------------------------------------------------------------
STATE (vue consolidée des blocs)
--------------------------------------------------------------------
state: object
  properties:
    abc_state : string enum [ "A", "B", "C", "NONE" ]

    block_e   : object
      properties:
        mapping_status: string enum [
          "OK", "MISSING", "AMBIGUOUS", "INCONSISTENT"
        ]
      required:
        mapping_status
      additionalProperties: true

    block_g   : object
      properties:
        fs_src : string enum [ "OK", "MISSING", "PARTIAL", "UNREADABLE" ]
        fs_dst : string enum [ "OK", "MISSING", "PARTIAL", "UNREADABLE" ]
        mirror : string enum [ "COMPLETE", "INCOMPLETE", "UNKNOWN" ]
      required:
        fs_src, fs_dst, mirror
      additionalProperties: true

    block_d   : object
      properties:
        qb_status   : string enum [ "SAFE", "UNSAFE" ]
        save_path_ok: boolean
        tags_state  : string enum [ "CONSISTENT", "MISMATCH", "UNKNOWN" ]
      required:
        qb_status, save_path_ok, tags_state
      additionalProperties: true

    block_h   : object
      properties:
        h_state: string enum [ "H0", "H1", "H2", "H3" ]
      required:
        h_state
      additionalProperties: true

    hash_state: object
      properties:
        hash_mode  : string enum [ "OFF", "PARTIAL", "FULL" ]
        hf_state   : string enum [ "HF0", "HF1", "HF2", "HF3", "HF4" ]
        primary_md5: [ string or null ]
        primary_md5_locations: object
          properties:
            src : string enum [ "PRESENT", "ABSENT", "UNKNOWN" ]
            dst : string enum [ "PRESENT", "ABSENT", "UNKNOWN" ]
            plex: string enum [ "PRESENT", "ABSENT", "UNKNOWN" ]
          required:
            src, dst, plex
          additionalProperties: true
      required:
        hash_mode, hf_state
      additionalProperties: true

  required:
    abc_state,
    block_e,
    block_g,
    block_d,
    block_h,
    hash_state
  additionalProperties: true

--------------------------------------------------------------------
DIAGNOSTIC
--------------------------------------------------------------------
diagnostic: object
  properties:
    overall_status: string enum [ "OK", "WARN", "ERROR", "BLOCKED" ]

    issues: array of object
      item properties:
        code           : string
        block          : string  # ex: "E","G","ABC","D","H","HASH"
        severity       : string enum [ "INFO", "WARN", "ERROR" ]
        blocked_by_code: boolean
      required:
        code, block, severity, blocked_by_code
      additionalProperties: true

    auto_fix_candidates: array of object
      item properties:
        type      : string
        confidence: number
      required:
        type, confidence
      additionalProperties: true

  required:
    overall_status
  additionalProperties: true

--------------------------------------------------------------------
MODE SOUPLE – RÈGLE
--------------------------------------------------------------------
- Tous les objets autorisent des propriétés supplémentaires
  (additionalProperties non forcé à false).
- Les propriétés et enums listés ci-dessus sont obligatoires lorsqu’ils
  sont marqués `required`.
- Le Case Book A3 définit quelles combinaisons d’états sont réellement
  possibles ou bloquantes.
- DOC_OV1 définit la logique de overall_status à partir de state.* et issues.

[FIN A4 DIGEST]
