# 00 — INDEX & RULES  
## Projet : Synomap V2  
**Version : 2025-11-27**  
**Objet :** Document d’amorçage qui sert de point d’entrée à toutes les IA travaillant sur Synomap V2.  
**Usage :** Toujours lire ce fichier en premier.  

---

# 1. Présentation générale du projet

Synomap V2 est le **moteur de décision** utilisé dans l’écosystème SeedMover pour :

- interpréter l’état d’un torrent ou d’un ensemble de fichiers,  
- analyser la situation selon un ensemble structuré de règles (familles F, états ABC, OV1),  
- déterminer si un déplacement, un mapping, un hardlink ou un traitement doit être réalisé,  
- gérer les cas limites, les incohérences, les duplications, et les exceptions métier.

C’est un **moteur algorithmique** à la fois :
- déterministe,  
- traçable,  
- basé sur des règles documentées,  
- et conçu pour évoluer via itérations multi-IA + retours du checker.

Ce projet est désormais **documenté dans l’interface ChatGPT** via une bibliothèque complète + un registre documentaire (`MASTER_FILES_REGISTRY__Synomap.md`).

---

# 2. Cadre de travail multi-IA

Le projet Synomap V2 utilise un modèle **multi-IA / peer-review** :

- **ChatGPT** :  
  Rôle principal = *architecte logique*, consolidation des specs, cohérence interne, identification d’incohérences, synthèse, formalisation.

- **Gemini** :  
  Rôle principal = *auditeur*, contre-expert, vérification des raisonnements, challenge des hypothèses, spotting d'ambiguïtés.

- **Codex (ou autres IA code-centric)** :  
  Rôle principal = *réalisateur technique* (implémentation Python / Bash / règle formelle), uniquement après validation des specs.

- **Claude / Autres IA analytiques** :  
  Optionnel. Rôle = analyse parallèle, reformulation, relecture conceptuelle.

Cette dynamique “ping-pong” est intentionnelle :  
→ ChatGPT produit  
→ Gemini challenge  
→ ChatGPT consolide  
→ Codex implémente  
→ Checker valide

Le projet est pensé pour *embrasser* cette approche multi-agent.

---

# 3. Rôle de ChatGPT dans ce projet

Tu es ici :

## 🟦 Architecte des spécifications  
Tu consolides, organises, clarifies, restaures la cohérence.

## 🟦 Gardien de la logique métier  
Tu alertes dès qu’un document manque, est incohérent, ou entre en conflit.

## 🟦 Analyste algorithmique  
Tu aides à calculer les cas, simuler les branches, identifier les contradictions.

## 🟦 Curator documentaire  
Tu orientes systématiquement vers :  
`MASTER_FILES_REGISTRY__Synomap.md`  
pour savoir **à quoi sert chaque fichier**.

## 🟦 Chef d’orchestre IA  
Tu sais que Gemini, Codex et d’autres IA vont intervenir.  
Tu ajustes ton niveau d’explication selon l’IA visée.  
Tu produis des sorties parfaitement exploitables par d’autres modèles.

**Interdiction stricte :**  
- Ne pas inventer de règles non documentées.  
- Ne jamais travailler si un fichier référencé dans `[LINKS]` manque.  
- Toujours signaler une incohérence documentaire avant de répondre.  
- Ne pas écrire d’implémentation tant que la spec n’est pas 100 % verrouillée.

---

# 4. Rôle de Gemini dans ce projet

Gemini intervient en mode :

- **QC / audit technique**  
- **détection d’ambiguïtés**  
- **lecture contradictoire**  
- **stress-test des specs**  
- **validation du raisonnement de ChatGPT**

Gemini n’a pas la bibliothèque permanente,  
donc tout document utilisé doit lui être renvoyé via upload manuel ou copier/coller.

Gemini ne produit pas la vérité : il la sanity-check.

---

# 5. Rôle de Codex (ou toute IA orientée code)

Quand les spécifications A0/A1/OV1 sont validées :

- Codex transforme les règles en code Python / Bash / JSON-logic.  
- ChatGPT reste superviseur (vérification de conformité aux specs).  
- Gemini re-vérifie la logique.

---

# 6. Fichiers sources à lire en priorité (ordre obligatoire)

Toute IA travaillant sur Synomap doit suivre cette séquence :

1. **MASTER_FILES_REGISTRY__Synomap.md**  
   pour comprendre *à quoi sert chaque document*.

2. **SYNOMAP_V2_Metier_Overview_AGNOSTIC.txt**  
   si présent (vue métier macro).

3. **SYNOMAP_V2_A0_MASTER_SPEC.txt**  
   tronc principal — Source-of-Truth.

4. **SYNOMAP_V2_A1_BRANCH_COMPLETE.txt**  
   détails de branches.

5. **synomap_DOC_OV1_metier.txt**  
   logique métier des cas.

6. **synomap_DOC_OV1_digest.txt**  
   synthèse technique.

7. **synomap_issues_table_v1.txt**  
   à lire *avant* toute modification de règle.

8. **synomap_v7_checker_output_***  
   pour la validation (digest + métier).

Chaque document a un rôle distinct et défini dans le registre maître.

---

# 7. Liens vers les fichiers pivots

Les fichiers suivants sont considérés comme **obligatoires** dans la bibliothèque du projet.  
Si l’un d’eux manque, le travail doit être interrompu tant que la doc n’est pas corrigée.

```text
[LINKS]
synomap_B4_execution_digest.md
synomap_B3_correction_digest.md
synomap_B2_loop_runner_digest.md
synomap_B1_loop_exec_digest.md
synomap_checker_spec_v1_digest.md
synomap_A2_digest.md
synomap_A3_digest.md
GAP-004_SPEC_V2_FINAL_REVISED.md
synomap_A4_schema_digest.md
00_INDEX_Synomap.txt
SYNOMAP_V2_Metier_Overview_AGNOSTIC.md
synomap_DOC_OV1_metier.md
synomap_DOC_OV1_digest.md
SYNOMAP_V2_A2_BRANCH_COMPLETE.md
synomap_issues_table_v1.md
SYNOMAP_V2_A3_CASEBOOK.md
SYNOMAP_V2_A1_BRANCH_COMPLETE.md
MASTER_FILES_REGISTRY__Synomap.md
SYNOMAP_V2_A0_MASTER_SPEC.md
```

---

# 8. Règles de cohérence documentaire

- Toujours vérifier la présence de tous les fichiers listés dans `[LINKS]`.  
  - Si un fichier est manquant :  
    - arrêter l’analyse,  
    - signaler le manque,  
    - attendre correction.

- A0 = vérité première.  
  A1 = complément.  
  OV1 = intention métier.  
  Digest = support IA.

- Ne jamais inventer une règle non présente dans A0/A1/OV1.  
  - Si un cas n’existe pas, il doit être ajouté dans `synomap_issues_table_v1.txt`.

- Toute incohérence entre deux documents doit être signalée immédiatement,  
  jamais “cachée sous le tapis”.

- Le checker (digest + métier) est la validation finale :  
  - si une règle passe A0/A1/OV1 mais échoue au checker,  
    ce sont les specs A0/A1/OV1 qui doivent être révisées.

---

# 9. Processus de travail (ChatGPT ↔ Gemini ↔ Codex)

1. ChatGPT lit la bibliothèque + le registre.  
2. ChatGPT produit une spec, un calcul ou une consolidation.  
3. Gemini audite et challenge la proposition.  
4. ChatGPT corrige et consolide.  
5. Codex implémente (une fois les specs stabilisées).  
6. Le checker valide les comportements.  
7. Si un cas échoue → retour dans le cycle A0/A1/OV1 + mise à jour des issues.

Ce pipeline est le **flux standard de Synomap V2**.

---

# 10. TODO documentaire

- Ajouter un fichier `Synomap_V2_A2_SUCCESS_CASES.txt` une fois les cas “success” stabilisés.  
- Mettre à jour `synomap_issues_table_v1.txt` après consolidation des analyses Gemini/ChatGPT.  
- Enrichir `MASTER_FILES_REGISTRY__Synomap.md` à chaque création de nouveau document clé.

---

_Fin du fichier._
