# MASTER FILES REGISTRY — SeedMover / Synomap  
**Version : 2025-11-27**  
**Objet :** Registre documentaire central de l’univers SeedMover  
**Usage :** Append-only — ajouter un bloc `## [FILE]` par artefact important  


---

# 🧩 SYNOMAP V2 — Documents principaux

## [FILE]
**NAME**    : `SYNOMAP_V2_A0_MASTER_SPEC.md`
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : spec  
**ROLE**    : Spécification maître du bloc A0 (tronc principal de Synomap V2).  
**USAGE**   : Source-of-Truth pour la logique des familles F? et le squelette global.  
**TAGS**    : `spec`, `A0`, `arbre_decision`, `familles_F`  


## [FILE]
**NAME**    : `SYNOMAP_V2_A1_BRANCH_COMPLETE.md`
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : spec  
**ROLE**    : Détails des branches A1, variantes, cas avancés.  
**USAGE**   : Toujours croiser avec A0 pour les cas subtils/ambiguës.  
**TAGS**    : `spec`, `A1`, `branches`, `cas_complexes`  


## [FILE]
**NAME**    : `synomap_DOC_OV1_metier.md`
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : metier  
**ROLE**    : Source métier décrivant OV1, familles F, contraintes, intentions.  
**USAGE**   : Document d’ancrage métier. À lire avant de toucher aux règles.  
**TAGS**    : `OV1`, `metier`, `familles_F`, `cas_usage`  


## [FILE]
**NAME**    : `synomap_DOC_OV1_digest.md`
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : digest  
**ROLE**    : Version condensée du document métier OV1.  
**USAGE**   : Support technique rapide pour les raisonnements IA.  
**TAGS**    : `OV1`, `digest`, `résumé`  


---

# 🧠 Issues, Checkers & Qualité

## [FILE]
**NAME**    : `synomap_issues_table_v1.md`
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : issues  
**ROLE**    : Table recensant erreurs, incohérences, cas non conformes.  
**USAGE**   : À consulter avant toute évolution des règles. Sert de backlog qualité.  
**TAGS**    : `issues`, `bugs`, `backlog`  


## [FILE]
**NAME**    : `synomap_v7_checker_output_digest.txt`  
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : checker_digest  
**ROLE**    : Résumé compact des résultats du Checker v7.  
**USAGE**   : Diagnostic rapide des familles problématiques.  
**TAGS**    : `checker`, `digest`, `validation`  


## [FILE]
**NAME**    : `synomap_v7_checker_output_metier.txt`  
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : checker_metier  
**ROLE**    : Version détaillée, lisible, du Checker v7.  
**USAGE**   : Analyse fine pour comprendre les erreurs et enrichir la table d’issues.  
**TAGS**    : `checker`, `metier`, `analyse`  


## [FILE]
**NAME**    : `00_RULES_synomap_cases.txt`  
**PROJECT** : SeedMover / Synomap_V2  
**TYPE**    : rules  
**ROLE**    : Règles opérationnelles concernant la nomenclature et le travail multi-IA.  
**USAGE**   : Référence comportementale pour travailler entre ChatGPT et Gemini.  
**TAGS**    : `rules`, `meta`, `nomenclature`  


## [FILE]
**NAME**    : synomap_A4_schema_digest.md
**PROJECT** : Synomap_V2  
**TYPE**    : spec_digest  
**ROLE**    : Digest du schéma JSON A4 (record torrent) : structure canonique des sorties du Checker Synomap v1.  
**USAGE**   : Référence technique pour toutes les représentations JSON (B1/B2/B3/B4). Sert à vérifier la cohérence structurelle.  
**TAGS**    : A4, schema, json, digest  


## [FILE]
**NAME**    : synomap_B1_loop_exec_digest.md
**PROJECT** : Synomap_V2  
**TYPE**    : spec_digest  
**ROLE**    : Digest du modèle d’exécution B1 (une passe du Checker). Décrit l’enchaînement des blocs et la production de torrent_record.  
**USAGE**   : Indispensable pour comprendre la sémantique d’un run B1, et pour valider l’ordre d’évaluation.  
**TAGS**    : B1, loop, execution, digest  


## [FILE]
**NAME**    : synomap_B2_loop_runner_digest.md
**PROJECT** : Synomap_V2  
**TYPE**    : spec_digest  
**ROLE**    : Digest du modèle B2 (Loop Runner) — exécutions successives, diff, convergence, persistences.  
**USAGE**   : Sert de guide pour comprendre le cycle global du Checker (runs répétés et convergence).  
**TAGS**    : B2, loop_runner, persistence, convergence, digest  


## [FILE]
**NAME**    : synomap_B3_correction_digest.md
**PROJECT** : Synomap_V2  
**TYPE**    : spec_digest  
**ROLE**    : Digest du modèle B3 (Correction). Formalise les actions correctives autorisées pour qBittorrent, FS, tags.  
**USAGE**   : Référence clé pour la génération d’ACTION_PLAN et la logique des actions sûres/non sûres.  
**TAGS**    : B3, correction, qbittorrent, actions, digest  


## [FILE]
**NAME**    : synomap_B4_execution_digest.md
**PROJECT** : Synomap_V2  
**TYPE**    : spec_digest  
**ROLE**    : Digest du modèle B4 (Execution). Décrit l’exécution réelle des actions (qB, FS, tags) et les invariants d’idempotence.  
**USAGE**   : Support pour formaliser les appels adapters et les conditions de validation/exécution.  
**TAGS**    : B4, execution, actions, adapters, digest  


## [FILE]
**NAME**    : synomap_checker_spec_v1_digest.md
**PROJECT** : Synomap_V2  
**TYPE**    : spec_digest  
**ROLE**    : Digest complet du Checker Spec v1 (A1). Synthèse stricte de l’ordre E→G→ABC→D→H→HASH→Output v7→DOC_OV1.  
**USAGE**   : Point d’entrée pour comprendre les règles bas niveau de chaque bloc et la logique de statut final.  
**TAGS**    : A1, checker, spec, digest  


## [FILE]
**NAME**    : SYNOMAP_V2_A0_MASTER_SPEC.md  
**PROJECT** : Synomap_V2  
**TYPE**    : spec  
**ROLE**    : Spécification maître A0 en version Markdown. Document canonique décrivant toutes les familles F0–F10, invariants, transitions et règles transverses.  
**USAGE**   : Doit remplacer la version TXT dans tous les travaux d’IA. Sert d’entrée principale pour ChatGPT/Gemini avant toute analyse A0.  
**TAGS**    : A0, spec, master, familles_F, transitions  


## [FILE]
**NAME**    : SYNOMAP_V2_A1_BRANCH_COMPLETE.md  
**PROJECT** : Synomap_V2  
**TYPE**    : spec  
**ROLE**    : Spécification complète A1 (TORRENT_ERROR), incluant les 16 scénarios, règles transverses, annexes MD5/JSONL et recommandations d’actions.  
**USAGE**   : Base métier pour toute implémentation de gestion d’erreur Synomap. À lire pour toute logique de réparation.  
**TAGS**    : A1, spec, errors, scenarios, annexes  


## [FILE]
**NAME**    : SYNOMAP_V2_A2_BRANCH_COMPLETE.md  
**PROJECT** : Synomap_V2  
**TYPE**    : spec  
**ROLE**    : Spécification complète A2 (TORRENT_SUCCESS), couvrant invariants stricts, portes d’entrée (SeedDirect, CrossSeed, Repair), règles A2-EXIT, matrice A2/Bx/Cy.  
**USAGE**   : Référence formelle pour la logique de succès. Indispensable pour comprendre les transitions F5→A2 et F7→A2.  
**TAGS**    : A2, spec, success, invariants, transitions  


## [FILE]
**NAME**    : SYNOMAP_V2_A3_CASEBOOK.md  
**PROJECT** : Synomap_V2  
**TYPE**    : casebook  
**ROLE**    : Recueil structuré des 10 cas majeurs A3 (Happy Path, CrossSeed, Repaired, Collision, Régressions A2→A0/A1, SRC Lost, Mapping Missing, HF4, Idempotence).  
**USAGE**   : 
- Sert de référence opérationnelle pour valider la logique A2 et ses transitions.  
- Support indispensable pour les sessions multi-IA (ChatGPT ↔ Gemini ↔ Codex).  
- Permet la comparaison directe entre trajectoire attendue et exécution du Checker.  
- À utiliser pour vérifier la cohérence A0/A1/A2 ↔ OV1 ↔ digest ↔ checker.  
**TAGS**    : A3, casebook, scénarios, success, erreur, régression, cross-seed, idempotence  


## [FILE]
**NAME**    : synomap_A2_digest.md  
**PROJECT** : Synomap_V2  
**TYPE**    : digest  
**ROLE**    : Digest de la branche A2 (TORRENT_SUCCESS) : vue synthétique des invariants, portes d’entrée et sorties.  
**USAGE**   : Support rapide pour comprendre le comportement A2 sans relire A2 complète.  
**TAGS**    : A2, digest, invariants  

## [FILE]
**NAME**    : synomap_A3_digest.md  
**PROJECT** : Synomap_V2  
**TYPE**    : digest  
**ROLE**    : Digest de la branche A3 (CASEBOOK), résumé des trajectoires principales.  
**USAGE**   : Point d’entrée compact pour naviguer dans A3.  
**TAGS**    : A3, digest, casebook  

## [FILE]
**NAME**    : GAP-004_SPEC_V2_REVISED.md  
**PROJECT** : Synomap_V2  
**TYPE**    : gap_spec  
**ROLE**    : Spécification corrective complète du GAP-004, intégrant les mises à jour post-audits.
              Formalise la distinction canonical_path/actual_path, le rôle du miroir, les clés de matching
              JSONL (Season Pack-ready), la politique mismatch, et l’état MIRROR_CANDIDATE.  
**USAGE**   : Référence technique majeure pour toute évolution Synomap V2 touchant aux mappings OMV/Synology,
              au miroir, aux hardlinks, au lookup JSONL/MD5, et aux invariants de structure torrent.
              Document à consulter avant toute modification des blocs G/F/E/H, ainsi que pour les évolutions A2/A3.  
**TAGS**    : gap004, spec, mapping, canonical_path, actual_path, jsonl, md5, mirror, season_pack, hardlinks  

## [FILE]
**NAME**    : SYNOMAP_V2_Metier_Overview_AGNOSTIC.md  
**PROJECT** : Synomap_V2  
**TYPE**    : metier_overview  
**ROLE**    : Vue d’ensemble métier de Synomap V2, indépendante de l’implémentation technique. Explique
              les objectifs, le périmètre, les grands blocs (A0/A1/A2/A3, B1–B4) et les grands principes.  
**USAGE**   : Document d’entrée pour tout humain ou IA découvrant Synomap. À lire en priorité avant les
              spécifications détaillées A0/A1/A2.  
**TAGS**    : overview, metier, synomap_v2, agnostique  



---

# 📚 Index & Documents d’analyse




---

# 📌 Notes
- Ce registre est **append-only** : on n’efface pas, on ajoute des blocs `[FILE]`.
- À chaque création ou upload de fichier important → ajouter un bloc.
- Ce fichier fait foi pour comprendre **à quoi sert chaque document** dans l’univers SeedMover/Synomap.

