# RELEASE NOTES — SYNOMAP V2.0 (GOLD MASTER)

**Date :** 27/11/2025
**Statut :** Spécifications Validées & Verrouillées
**Version :** 2.0-specs

---

## 1. VUE D'ENSEMBLE
Cette release **V2.0** marque la refonte complète de l'architecture Synomap.
Le système abandonne l'approche monolithique "Script Bash" pour adopter une architecture modulaire, agnostique et déterministe.

**Objectif principal :** Garantir la cohérence des données entre un Client de téléchargement, un Support Source et un Support Destination, sans risque de perte de données.

---

## 2. NOUVEAUTÉS MAJEURES

### 🚀 Architecture Agnostique
* Abandon des concepts spécifiques "OMV" ou "Synology" dans le cœur du moteur.
* Adoption du modèle universel : **Source** (B) ↔ **Destination** (C) piloté par un **Client** (A).
* Introduction de **GAP-004** : Distinction stricte entre *Canonical Path* (Téléchargement) et *Actual Path* (Média), réconciliés par des miroirs (Hardlinks).

### 🧠 Automate A0 (11 Familles)
* Modélisation exhaustive de tous les états intermédiaires (F0 à F10).
* **Sécurité F9 (Collision Logique) :** Interdiction stricte d'écraser des données valides qui ne correspondent pas au torrent attendu.
* **Sécurité F7 (Corruption) :** Pipeline de réparation obligatoire via la Source avant toute reconstruction de la Destination.

### 🌳 Branches de Vie Complètes
* **Branche A1 (Erreur) :** Gestion défensive de 16 scénarios d'échec. Le moteur passe en lecture seule sur la destination.
* **Branche A2 (Succès) :** Définition stricte du succès avec 3 portes d'entrée :
    * *SeedDirect* (Téléchargement classique).
    * *CrossSeed* (Import immédiat de données existantes).
    * *Repaired* (Succès après reconstruction).

### 🔍 Checker V7 (Moteur d'Analyse)
* Analyse sur 6 dimensions indépendantes : **E** (Mapping), **G** (Filesystem), **ABC** (Intention), **D** (Client), **H** (Source), **HASH** (Contenu).
* Calcul déterministe du statut global : `BLOCKED > ERROR > WARN > OK`.
* Nouveau format de sortie JSON standardisé (Schema A4).

### ⚙️ Pipeline d'Exécution (Série B)
* **B1 (Diagnostic) :** Purement fonctionnel, sans effet de bord.
* **B2 (Runner) :** Gestion de la persistance et de la convergence (Idempotence).
* **B3 (Planner) :** Planification d'actions sûres uniquement.
* **B4 (Executor) :** Exécution contrôlée avec adaptateurs (API qB, FS).

---

## 3. MANIFESTE DOCUMENTAIRE (GOLD MASTERS)

Les fichiers suivants constituent la **Source de Vérité** (SoT) pour toute implémentation V2.

| ID | Fichier | Rôle |
| :--- | :--- | :--- |
| **A0** | `SYNOMAP_V2_A0_MASTER_SPEC.md` | Logique cœur & Familles F0-F10 |
| **A1** | `SYNOMAP_V2_A1_BRANCH_COMPLETE.md` | Gestion des erreurs & Scénarios S1-S16 |
| **A2** | `SYNOMAP_V2_A2_BRANCH_COMPLETE.md` | Invariants de succès & A2-EXIT |
| **A3** | `SYNOMAP_V2_A3_CASEBOOK.md` | Plan de test fonctionnel (10 Cas) |
| **A4** | `synomap_A4_schema_digest.md` | Schéma JSON de sortie |
| **OV1**| `synomap_checker_spec_v1_digest.md` | Logique de statut global |
| **B1** | `synomap_B1_loop_exec_digest.md` | Moteur de diagnostic |
| **B2** | `synomap_B2_loop_runner_digest.md` | Moteur de persistance |
| **B3** | `synomap_B3_correction_digest.md` | Moteur de décision |
| **B4** | `synomap_B4_execution_digest.md` | Moteur d'action |

---

## 4. BREAKING CHANGES (Migration V1 → V2)

* **Format de sortie :** Le format de log textuel V1 est remplacé par le JSON structuré V2 (A4). Les outils de parsing existants doivent être mis à jour.
* **Logique de suppression :** La V2 interdit toute suppression automatique (`rm`) dans le module d'exécution B4 v1. Les scripts de nettoyage V1 doivent être désactivés ou migrés vers des politiques manuelles.
* **Mapping :** Le format du fichier de mapping est conservé, mais son interprétation est stricte (Bloc E). Tout mapping ambigu bloque désormais le traitement (F2/F4/F6/F8/F10).

---

## 5. PROCHAINES ÉTAPES

1.  **Code :** Implémentation des modules Python/Bash suivant les specs B1-B4.
2.  **Test :** Exécution des scénarios du CaseBook A3 sur environnement de staging.
3.  **Déploiement :** Bascule progressive des torrents en mode "Observation" (B1 seul) avant activation des corrections (B3/B4).

---
*Validé par l'Architecte & l'Auditeur QC - 27/11/2025*
