📘 FEATURE — MappingDB_v1
(Document métier / fonctionnel — Source-of-Truth pour la Feature 01 de Synomap V2)

1. Contexte métier
Synomap V1 reposait sur un fichier texte mapping_entries.txt produit par les scripts post-process Sonarr/Radarr.
Ce fichier, bien que fonctionnel, souffrait de plusieurs limitations :
    • absence de structure formelle ;
    • ambiguïtés entre plusieurs mappings possibles ;
    • perte d’historique ;
    • fragilité (corruption, lignes manquantes, doublons) ;
    • dépendance à du parsing texte dispersé au fil des scripts ;
    • état du système éclaté entre : filesystem, qBittorrent, fichiers logs, et mapping TXT.
Dans Synomap V2, la fiabilité est une exigence absolue :
toute décision B1/B3/B4 doit se baser sur un état stable, lisible, résilient et vérifiable.
Il est donc nécessaire de remplacer mapping_entries.txt par une base SQLite structurée, conçue pour représenter :
    • l’identité torrent (infohash),
    • la version consolidée du mapping,
    • les événements successifs (imports Sonarr/Radarr),
    • les réconciliations filesystem / qBittorrent,
    • tout ce qui alimentera le modèle A4 + le Checker B1.
Cette base est la toute première pierre technique de Synomap V2.

2. Objectif global
Créer une base SQLite solide, extensible et durable, nommée synomap.db, qui deviendra :
    • la source de vérité pour tous les mappings File ↔ Torrent ;
    • l’unique référence pour le Checker B1 ;
    • le support de correction pour le Planner B3 ;
    • le socle de décision pour l’Executor B4 ;
    • la mémoire de l’état d’un torrent, même si Sonarr/Radarr/QB perdent temporairement de l’information.
L'objectif n’est pas encore d’exécuter des actions, mais de poser le fondement de la logique A4.

3. Description fonctionnelle
La feature MappingDB_v1 doit permettre :
✔️ 1. Création d’une base SQLite structurée
Avec au minimum trois tables fonctionnelles :
    • mapping_events
Événements bruts Sonarr/Radarr (post-process).
Contient l’historique complet.
    • mapping_latest
Vue consolidée du dernier mapping connu par infohash.
    • mapping_diagnostics
Informations permettant de générer les blocs A4 → State/Diagnostic.
✔️ 2. Import “legacy” depuis mapping_entries.txt
Pour migrer l’existant vers SQLite sans perte.
✔️ 3. API Python simple et robuste
Le module permettra :
    • d'insérer un événement Sonarr/Radarr ;
    • de récupérer le mapping par infohash / par chemin / par groupe ;
    • de retourner une structure 1:1 compatible A4 (partielle dans cette feature) ;
    • de détecter les ambiguïtés “multi-candidats” ;
    • de signaler les trous (missing mapping) ;
    • d’émettre des diagnostics basiques : OK / MISSING / MULTI / INVALID.
✔️ 4. Extensibilité future
La structure doit anticiper les évolutions :
    • ajouts d’attributs,
    • stockage des hashes de fichiers (MD5/SHA1),
    • flags d’état utilisés par Checker/Planner,
    • liens vers les actions B3/B4.

4. Entrées
🔹 Entrées directes du module MappingDB_v1
    • Données brutes venant de Sonarr/Radarr (POSTPROCESS) :
        ○ infohash (ou HASH QB si fourni),
        ○ chemin source sur OMV,
        ○ chemin destination attendu sur NAS,
        ○ type (movie/tv),
        ○ indexer / release group (si connu),
        ○ timestamp,
        ○ liste des fichiers importés.
    • Legacy :
        ○ fichier mapping_entries.txt (import unique lors de la migration).
    • Scanner Filesystem (optionnel, utilisé par tests ultérieurs) :
        ○ liste de fichiers présents dans /srv/.../completed/,
        ○ hardlinks sur NAS,
        ○ correspondances inode.
    • Entrées Synomap (pour version ultérieure) :
        ○ A4 schema (identity/path/state),
        ○ mais ici, on se limite à construire les briques nécessaires.
🔹 Appels externes (indirects)
    • Aucun pour cette feature.
Les appels qBittorrent API appartiendront au Checker.

5. Sorties
🔹 Sorties du module MappingDB_v1 :
    • Objet Python structuré représentant un mapping consolidé :
{
  "infohash": "ABC123...",
  "source_path": "/mnt/omv/torrents/.../",
  "dest_path": "/mnt/syno/...",
  "type": "tv" | "movie",
  "events": [...],
  "diagnostic": {
      "status": "OK" | "MISSING" | "MULTI" | "CORRUPT",
      "detail": "...",
      "candidates": [...]
  }
}
    • Logique compatible A4 (partielle) :
        ○ Identity (hash, type),
        ○ Paths (source → dest),
        ○ Diagnostic simple,
        ○ State minimal (OK/MISSING/MULTI).
    • Fichier synomap.db créé automatiquement s’il n’existe pas.
    • Logs structurés en JSON (niveau INFO/WARN/ERROR).

6. Cas nominaux
Cas nominal simple — un torrent géré correctement par Sonarr
    1. Sonarr post-process génère un événement :
infohash=X, src=/omv/..., dst=/syno/...
    2. MappingDB_v1 insère cet événement dans mapping_events.
    3. MappingDB_v1 met à jour mapping_latest :
infohash=X  
src=/omv/...  
dst=/syno/...  
type=tv
    4. Un appel get_mapping(infohash=X) retourne :
        ○ un mapping unique,
        ○ clair,
        ○ diagnostiqué “OK”.

7. Cas limites / scories
1. Mapping manquant
Torrent présent dans qBittorrent mais absent de la DB → diagnostic = MISSING.
2. Multi-candidats (collision)
Plusieurs événements Sonarr/Radarr donnent des chemins différents pour le même hash.
Diagnostic = MULTI, candidates listées.
3. Chemin incohérent
L’événement pointe vers un répertoire inexistant.
Diagnostic = CORRUPT.
4. Import legacy ambigu
mapping_entries.txt contient plusieurs lignes contradictoires.
Diagnostic = LEGACY_SCORY / MULTI.
5. Données partielles
Événement incomplet (pas de dest_path, pas de type).
L’événement est stocké mais le mapping_latest reste en PARTIAL.
6. Type invalide
Saisie invalide (ex: “season-pack-mixed”) → flag INVALID_TYPE.
7. Timeout / lock DB
En cas de lock SQLite prolongé → erreur propre + log.

8. Règles métier obligatoires
    • La DB est la source unique pour reconstituer le mapping File ↔ Torrent.
    • Un infohash doit correspondre à un unique mapping consolidé (MULTI = état d’erreur).
    • Chaque événement doit être historisé — jamais écrasé.
    • mapping_latest représente l’état “vérité actuelle”.
    • Toute incohérence doit être signalée via diagnostic, jamais silencieuse.
    • Aucun nettoyage automatique dans cette feature (sera géré en B3/B4).
    • Compatibilité totale avec A4 / B1 :
        ○ Identity = infohash + type,
        ○ Path = source/destination,
        ○ Diagnostic = conforme AUX catégories A4,
        ○ State minimal = {OK, MISSING, MULTI, PARTIAL}.
    • La DB doit être prête à intégrer de futurs champs (hash fichiers, flags B1, décisions B3).

9. Exemples d’I/O
🔹 Exemple d’entrée (événement Radarr)
{
  "infohash": "C7A3AB...",
  "source": "/data/torrents/completed/Movies/Movie.2023.1080p/",
  "destination": "/syno/movies/Movie (2023)/",
  "type": "movie",
  "timestamp": "2025-11-28T18:12:34Z",
  "release_group": "FGT"
}
🔹 Exemple de sortie
{
  "infohash": "C7A3AB...",
  "source_path": "/data/torrents/completed/Movies/Movie.2023.1080p/",
  "dest_path": "/syno/movies/Movie (2023)/",
  "type": "movie",
  "diagnostic": {
      "status": "OK",
      "detail": "unique mapping consolidated"
  }
}
🔹 Exemple de transition attendue
Input : deux événements Radarr pour le même hash, avec chemins différents.
Output : diagnostic = MULTI,
candidates = [path1, path2],
mapping_latest = “UNDECIDED”.

10. Notes diverses
    • Cette feature ne gère aucune action filesystem (hardlink / correction).
C’est du ressort de B3/B4.
    • Cette feature ne parle pas encore au checker B1, mais prépare toutes ses entrées.
    • Le design doit respecter A0 + A4 + OV1 :
c’est la fondation du modèle Synomap V2.
    • La migration legacy doit être répétable et idempotente.
    • La DB devra ensuite être reliée à :
        ○ B1 (Checker) pour reconstituer A4 complet,
        ○ B3 (Planner) pour corriger les anomalies,
        ○ B4 (Executor) pour agir sur le système.
    • Cette feature est volontairement “simple” mais critique :
si cette base est solide, tout Synomap V2 sera solide.
