
# GAP-004 — Spécification V2 Révisée (post-audit Gemini)

## 0. Objet du document révisé
Cette version intègre les corrections critiques identifiées par l’audit Gemini concernant :
- la distinction stricte entre canonical_path (logique torrent) et actual_path (logique médias),
- l’impossibilité de reconstruire real_syno_path via canonical_path,
- l’obligation d’utiliser JSONL Sonarr comme Source de Vérité pour la destination,
- la place exacte du MD5 Rescue,
- le rôle indispensable du miroir, même avec le renommage interne de qBittorrent.

Le document remplace entièrement la version précédente du GAP-004.

---

# 1. Canonical Path (logique torrent) : définition immuable
[INTEGRATION_PURE]

### 1.1. Canonical = vérité torrent
Le canonical_path est dérivé **exclusivement** du chemin relatif dans le .torrent.
Il est :
- neutre,
- normalisé (Unicode NFC, slash unique, trim espaces),
- **immuable** : ne change jamais, même en présence d’un fichier physique différent.

### 1.2. Fonction du canonical_path
- sert de référence pour le client torrent (qBittorrent, Deluge, etc.),
- sert à structurer les hardlinks “miroir” nécessaires au seed,
- ne prédit aucune structure réelle sur Synology.

---

# 2. Actual Path (logique médias) : vérité physique
[EXTENSION]

### 2.1. actual_path = emplacement réel sur Synology
Le fichier présent sur Synology peut :
- être renommé,
- être déplacé,
- avoir une structure totalement différente du canonical_path.

### 2.2. Où le trouve-t-on ?
Trois sources possibles :

1. **JSONL Sonarr** → Priorité absolue  
   C’est l’information exacte du post-processing (renommage, déplacement).

2. **MD5 Index & Rescue** → Fallback  
   Permet de retrouver un fichier dont le JSONL ne parle pas.

3. **Strict (canonical + syno_root)** → **INTERDIT**  
   Cette stratégie est supprimée car incompatible avec Sonarr/Plex.

---

# 3. Mappings corrigés
[MAJOR_UPDATE] [INTEGRATION_PURE]

### 3.1. OMV (source torrent)
```
real_omv_path = omv_root + "/" + canonical_path
```
→ valide : OMV ne renomme jamais.

### 3.2. Synology (destination Sonarr/Plex)
```
real_syno_path ≠ syno_root + "/" + canonical_path   # INTERDIT
```

### 3.3. Nouvelle règle V2
```
real_syno_path = lookup_jsonl(info_hash, file_id)
              OR lookup_md5_index(md5)
```

---

# 4. Politique mismatch corrigée
[MAJOR_UPDATE]

### 4.1. OMV (source)
Ordre :
1. strict (canonical)
2. MD5 fallback

### 4.2. Synology (destination)
Ordre :
1. JSONL Sonarr (source de vérité)
2. MD5 Index & Rescue
3. STRICT → supprimé

---

# 5. MD5 : rôle exact
[INTEGRATION_PURE]

Le MD5 identifie un contenu.  
Il ne définit ni :
- son nom,
- son chemin,
- sa structure logique.

MD5 est l’outil pour savoir :
> “Ces deux fichiers sont les mêmes.”

Mais il ne dit pas :
> “Où doit se trouver tel fichier pour que qBittorrent ou Plex soit heureux.”

---

# 6. Pourquoi le miroir reste obligatoire
[CLARIFICATION_CRITIQUE]

### 6.1. qB “renomme” mais ce n’est qu’un alias interne
qB renomme **la référence interne**, pas le fichier physique.

- Les trackers utilisent toujours les noms torrent.
- La structure torrent reste strictement imposée.
- Plex/Sonarr, eux, renommeront physiquement.

Ces deux mondes sont incompatibles.

### 6.2. Le miroir permet :
- à qB de seeder dans une structure torrent 100% stable,
- à Plex de lire dans une structure optimisée 100% indépendante,
- à Synomap de faire le lien entre les deux.

### 6.3. Conclusion
MD5 ne remplace pas le miroir :  
il **valide** que les deux arborescences pointent vers le même contenu.

---

# 7. État “MIRROR_CANDIDATE”
[NOUVEL ÉTAT] [EXTENSION]

Lorsqu’un fichier :
- existe sur OMV sous canonical_path,
- et existe sur Syno sous actual_path (trouvé via JSONL ou MD5),
- et qu’aucun hardlink miroir n’existe,

alors :

```
G = MIRROR_CANDIDATE
extra.actual_path = ...
```

Cet état servira aux plans d’action pour :
- créer le hardlink,
- reconstruire le miroir propre,
- aligner les structures.

---

# 8. Structure file_list mise à jour
[INTEGRATION_PURE] [EXTENSION]

```
relative_path
canonical_path
size
md5
present_omv
present_syno
present_client

extra:
    actual_path
    actual_path_source = "jsonl" | "md5" | null
    mtime_omv
    mtime_syno
```

---

# 9. Issues liées au renommage / mismatch
[EXTENSION]

- PATH_UNEXPECTED_MD5_MATCH
- MD5_DUPLICATE_LOCATIONS
- SYNOPATH_MISSING
- SYNOPATH_JSONL_MISMATCH
- MIRROR_CANDIDATE
- CANONICAL_UNRESOLVED_ON_SYNO

---

# 10. Résumé des modifications par rapport à la précédente version
[SUMMARY]

- ❌ Suppression de “real_syno_path = syno_root + canonical_path”.
- ✔ Ajout source de vérité JSONL pour Synology.
- ✔ MD5 Rescue utilisé seulement en fallback.
- ✔ canonical_path = logique torrent, jamais utilisé pour deviner la structure Plex.
- ✔ actual_path = réalité Synology.
- ✔ Ajout de l’état MIRROR_CANDIDATE.
- ✔ Clarification du rôle du miroir comme structure B/T duale.
- ✔ Clarification que le renommage qB n’est qu’un alias interne.

---

# 11. État du GAP-004 Révisé
**VALIDÉ — compatible Gemini — stable — autoportant**

