# SYNOMAP_V2_A1_BRANCH_COMPLETE.txt

```

SYNOMAP V2 — BRANCHE A1 COMPLÈTE
=================================

DOCUMENT DE SPÉCIFICATION — LIGNE A1 (TORRENT_ERROR)
-----------------------------------------------------

Ce document regroupe :

• Les 16 scénarios complets de la ligne A1 (A1 + Bx + Cy)
• Les descriptions normalisées
• Les statuts globaux associés
• Les recommandations d’actions
• Toutes les règles transversales définies en chemin
• Les annexes consolidées (MD5, JSONL, SET_ATTENDU, règles Destination / Source)
• La philosophie V2 pour la réparation, la détection, et l’usage API Sonarr

----------------------------------------------------------------------

INTRODUCTION
============

A1 = TORRENT_ERROR  
Le client torrent signale une erreur structurelle :  
• fichiers manquants  
• path invalide  
• corruption  
• problème de montage  
• dossier déplacé  
• erreur IO  
• info-hash existant mais fichiers partiellement ou totalement absents  

Dans A1 : le torrent est **inutilisable comme source de vérité**.  
La logique repose exclusivement sur B (source) et C (destination).

----------------------------------------------------------------------

BLOC B — RAPPEL DES ÉTATS
=========================

B0 — Source absente  
B1 — Source partielle (incomplète mais non corrompue)  
B2 — Source complète (SET_ATTENDU complet + MD5 validés)  
B3 — Source incohérente (corruption, ambiguïtés, fragments non fiables)

----------------------------------------------------------------------

BLOC C — RAPPEL DES ÉTATS
=========================

C0 — Destination absente  
C1 — Destination partielle  
C2 — Destination complète  
C3 — Destination incohérente / corrompue

----------------------------------------------------------------------

RÈGLES TRANSVERSES (A1)
=======================

RULE_FS_01 — PURGE_SOURCE_ONLY_WHEN_SAFE  
-----------------------------------------
Synomap (ou un script dépendant) n’est autorisé à modifier le filesystem **que** sur la source,  
et uniquement pour une **purge** après validation totale de la migration (C2 OK, utilisateur OK).

RULE_DESTINATION_MANAGED_BY_APP  
--------------------------------
Synomap ne doit jamais écrire/corriger directement la destination.  
Toute action doit passer par :  
• l’API Sonarr/Radarr (Rescan, Manual Import)  
ou  
• une action manuelle dans l’UI Sonarr (Manual Import)

RULE_NEVER_CREATE_TORRENT_FROM_SOURCE  
--------------------------------------
Jamais créer un .torrent depuis les fichiers présents en local.  
Un nouveau torrent = nouveau info_hash = perte du seed + incohérence métier.

RULE_REDOWNLOAD_FOR_SEED  
-------------------------
Si l’utilisateur souhaite continuer à seeder :  
→ Re-téléchargement d’un torrent officiel.  
Jamais une reconstruction locale.

RULE_MD5_CANONICAL  
-------------------
Le MD5 est la seule clé universelle pour identifier un fichier indépendamment du nom, du dossier, du torrent, du renaming Sonarr/Plex.

----------------------------------------------------------------------

SCÉNARIOS A1 — LISTE COMPLÈTE (16 CAS)
======================================

A1/B0/C0 — S1  
-------------
Torrent mort, pas de source, pas de destination.  
→ Rien à faire, re-download nécessaire.  
Global : FATAL_NO_TRUSTED_COPY_ANYWHERE.

A1/B0/C1 — S2  
-------------
Torrent mort, pas de source, destination partielle.  
→ Destination incomplète non récupérable.  
Global : ERROR_NO_TRUSTED_COPY.

A1/B0/C2 — S3  
-------------
Torrent mort, pas de source, destination complète.  
→ Média OK, seed perdu.  
Global : OK_MEDIA_INTACT_C_AS_TRUTH + WARN_LOST_SEED.

A1/B0/C3 — S4  
-------------
Torrent mort, destination incohérente, pas de source.  
→ Aucune copie fiable.  
Global : FATAL_NO_TRUSTED_COPY_ANYWHERE.

A1/B1/C0 — S5  
-------------
Source partielle, destination absente.  
→ Partiellement récupérable, mais jamais complet.  
Global : ERROR_PARTIAL_CONTENT_NO_TRUSTED_SET.

A1/B1/C1 — S6  
-------------
Source partielle, destination partielle.  
→ Analyse par fichier, partiellement récupérable.  
Global : WARN_PARTIAL_MEDIA_RECOVERABLE + ERROR_PARTIAL_CONTENT_NO_TRUSTED_SET.

A1/B1/C2 — S7  
-------------
Source partielle, destination complète.  
→ Destination = vérité ; purge source possible.  
Global : OK_MEDIA_INTACT_C_AS_TRUTH + WARN_SOURCE_REDUNDANT_OR_CORRUPT.

A1/B1/C3 — S8  
-------------
Source partielle, destination incohérente.  
→ Destination non sûre, source non sûre → fatal.  
Global : FATAL_NO_TRUSTED_COPY_ANYWHERE.

A1/B2/C0 — S9  
-------------
Source complète, destination absente.  
→ Possibilité d'import via SONARR API.  
Global : OK_MEDIA_RECOVERABLE_FROM_SOURCE.

A1/B2/C1 — S10  
--------------
Source complète, destination partielle.  
→ Réparation possible (via Sonarr).  
Global : WARN_DEST_INCOMPLETE_BUT_SOURCE_OK.

A1/B2/C2 — S11  
--------------
Source complète, destination complète.  
→ Média intact, seed mort.  
Global : OK_MEDIA_INTACT + WARN_LOST_SEED.

A1/B2/C3 — S12  
--------------
Source complète, destination incohérente.  
→ Destination réparable via API Sonarr.  
Global : ERROR_DEST_CORRUPTED_BUT_SOURCE_OK.

A1/B3/C0 — S13  
--------------
Source incohérente, destination absente.  
→ Aucune copie fiable.  
Global : ERROR_NO_TRUSTED_COPY.

A1/B3/C1 — S14  
--------------
Source incohérente, destination partielle.  
→ Analyse par fichier ; partiellement récupérable mais SET_ATTENDU absent.  
Global : ERROR_PARTIAL_CONTENT_NO_TRUSTED_SET.

A1/B3/C2 — S15  
--------------
Source incohérente, destination complète.  
→ Destination = vérité ; purge source.  
Global : OK_MEDIA_INTACT_C_AS_TRUTH.

A1/B3/C3 — S16  
--------------
Source incohérente, destination incohérente.  
→ Catastrophe totale.  
Global : FATAL_NO_TRUSTED_COPY_ANYWHERE.

----------------------------------------------------------------------

ANNEXE 1 — MD5 & POLITIQUE DE HASH
==================================

• Le MD5 est obligatoire pour la canonisation des fichiers.  
• Le hash est calculé :  
  - au moment où un fichier atteint 100% dans la source  
  - via scan initial  
  - via MD5 Rescue  
• Le hash est stocké dans une table SQL interne (file_hashes).  
• Le hash ne dépend pas du nom ni du chemin.  
• Permet de résoudre les collisions de nom, les renamings Sonarr/Plex, et les multi-seasons packs.

----------------------------------------------------------------------

ANNEXE 2 — JSONL (Mapping Sonarr)
=================================

• JSONL = fichier décrivant exactement ce que Sonarr a importé.  
• Clé de jointure :  
  - info_hash (torrent)  
  - + relative_path OU file_size (pour packs multi-fichiers)  
• JSONL > toute reconstruction heuristique.  
• real_syno_path doit toujours venir du JSONL.  
• Si JSONL absent → fallback MD5 Rescue.

----------------------------------------------------------------------

ANNEXE 3 — RÈGLES DESTINATION
=============================

• La destination est toujours pilotée par Sonarr/Radarr.  
• Synomap ne touche jamais les fichiers dans les dossiers "managed".  
• Toute action passe par :  
  - API Sonarr : RescanSeries, ManualImport, RefreshSeries  
  - ou action manuelle.

----------------------------------------------------------------------

ANNEXE 4 — PURGE SOURCE
=======================

• La seule action filesystem autorisée côté Synomap.  
• Autorisée lorsque :  
  - C2 = destination complète  
  - utilisateur confirme  
• But : libérer l’espace, pipeline clean.  
• Journalisation obligatoire.

----------------------------------------------------------------------

FIN DU DOCUMENT — BRANCHE A1 COMPLÈTE
=====================================



PATCH V2 — AJOUTS SPÉC A1 (Gemini QC)
=====================================

1) SET_ATTENDU (A1)
-------------------
En contexte A1, SET_ATTENDU est défini par ordre de priorité :
1. Métadonnées du client torrent.
2. Fichier .torrent local.
3. JSONL Sonarr (si existant).
4. Table MD5 persistée.
Si aucune source n’existe → SET_ATTENDU = INDETERMINABLE (B3 forcé).

2) S11 — Purge Source
---------------------
Ajout : “Puisque C2 est complet et A1 cassé, la source B2 est redondante.
Une purge source est recommandée (RULE_FS_01).”

3) API Sonarr — Chemin réel
---------------------------
Toute réparation via API Sonarr nécessite real_omv_path :
real_omv_path = omv_root + canonical_path.
Synomap doit reconstruire ce chemin avant appel API.

4) RULE_REDOWNLOAD_FOR_SEED — Workflow Reseed
----------------------------------------------
Deux stratégies :
1. Reseed en pointant vers le répertoire existant (Recheck).
2. Téléchargement propre dans un nouveau répertoire.
Synomap ne force jamais l’une ou l’autre.

```