SYNOMAP V2 — BRANCHE A2 COMPLETE
##

DOCUMENT DE SPÉCIFICATION — LIGNE A2 (TORRENT_SUCCESS)
###----------------

Ce document regroupe :
• Invariants A2-I1 à A2-I10
• Portes d'entrée (SeedDirect, CrossSeed, Repaired)
• Règles de sortie (A2-EXIT-D/G/H/HASH/E)
• Matrice A2 / Bx / Cy
(Synthèse complète conforme aux validations ChatGPT + Gemini)

###
1. INTRODUCTION
A2 = TORRENT_SUCCESS
###
L'état A2 représente un torrent complété et certifié par le client.
Il nécessite un hash-check complet 100 % valide et une cohérence stricte
entre source (B), destination (C) et mapping (B1–B3).

A2 est un état stable, mais réversible en cas de dérive (A2-EXIT).

###
2. INVARIANTS (A2-I1 à A2-I10)
###
[I1] Hash-check client 100 % valide.
[I2] Infohash figé et immuable.
[I3] SoT fixé selon le sous-rôle (B ou C).
[I4] Stabilité qB (save_path_ok, qb_status SAFE).
[I5] Synchronisation B/C/mirror complète.
[I6] SET_ATTENDU satisfait.
[I7] Aucun bloc bloquant (DOC_OV1).
[I8] Idempotence : A2 persiste si l'environnement est stable.
[I9] Aucune action B3/B4 applicable.
[I10] Stabilité HASH (hf_state ≤ HF2).

###
3. PORTES D’ENTRÉE VERS A2
###
A2-SeedDirect :
    F1/F3 → téléchargement complet + hash-check OK.
A2-CrossSeed :
    F5 → C2 complet → hash-check OK sur C.
A2-Repaired :
    F7 → réparation complète → hash-check OK.

Transitions interdites :
    F0, F2, F4, F6, F8, F9, F10, A1.

###
4. RÈGLES DE SORTIE (A2-EXIT)
###
A2 → A0 si :
    - save_path_ok=FALSE
    - tags mismatch
    - fs_dst!=OK
    - mirror!=COMPLETE
    - h_state ∈ {H1,H2,H3}
    - hf_state ∈ {HF3,HF4}
    - mapping_status!=OK
    - qb_status=PAUSED (non demandé)

A2 → A1 si :
    - qb_status=UNSAFE
    - erreur client explicite

A2 → A2 si :
    - invariants conservés
    - overall_status ∈ {OK, WARN acceptable}

###
5. MATRICE A2 / Bx / Cy
###
Seule combinaison valide :
    B ∈ {B1,B2,B3} ET C = C2

IMPOSSIBLE :
    B0, B4
    C0, C1, C3, C4

INVALID (A2-EXIT) :
    toute dérive hors (B1-3,C2)

###
6. CONCLUSION
###
A2 est un état strict, qui garantit la cohérence et la sécurité maximales
du torrent. Toute anomalie entraîne une sortie via A2-EXIT et un retour
dans l’analyse dynamique A0/A1.
