# SYNOMAP V2 — A3 CASE BOOK ÉTENDU  
### Version finale

Ce document regroupe les **10 cas majeurs** du bloc A3 de Synomap V2.  
Chaque cas conserve son **contenu original à la lettre près**, mais bénéficie d’une mise en forme Markdown structurée.

---

# 1. CAS 1 — HAPPY PATH COMPLEXE (Download → SeedDirect)

**BUT**  
Download normal sans cross-seed ni corruption.

**INPUT**  
E=OK, G=(SRC OK, DST C0/C1, mirror INCOMPLETE), ABC=A, D=(ACTIVE, save_path_ok=TRUE), H=H0, HASH=HF0.

**TRAJECTOIRE**  
F1 → F3 → hash-check client → A2-SeedDirect.

**INVARIANTS**  
A2-I1, A2-I5, DOC_OV1=OK.

**EXPECT**  
overall_status=OK, state.abc_state=C, A2-SeedDirect atteint.

---

# 2. CAS 2 — CROSS-SEED (F5 → A2-CrossSeed)

**BUT**  
Destination déjà complète, hash-check validé sur C.

**INPUT**  
E=OK, G=(DST OK, mirror COMPLETE, SRC OK/MISSING/PARTIAL), ABC=C, D=(ACTIVE), H=H0, HASH HF0/HF1.

**TRAJECTOIRE**  
F5 → hash-check → A2-CrossSeed.

**INVARIANTS**  
A2-I3, A2-I5, DOC_OV1=OK.

**EXPECT**  
overall_status=OK, A2-CrossSeed atteint.

---

# 3. CAS 3 — RÉPARATION (F7 → A2-Repaired)

**BUT**  
C3 corrompu, réparation via B, reconstruction C.

**INPUT**  
E=OK, G=DST=C3, mirror INCOMPLETE, H=H0/H1, HASH=HF3.

**TRAJECTOIRE**  
F7 → réparation B → reconstruction C → hash-check → A2-Repaired.

**INVARIANTS**  
A2-I1, A2-I5.

**EXPECT**  
overall_status=OK, A2-Repaired atteint.

---

# 4. CAS 4 — COLLISION (F9) → BLOQUANT

**BUT**  
C contient des fichiers valides mais d’un autre torrent.

**INPUT**  
E=OK, G=DST=C4, mirror UNKNOWN, H=H0.

**TRAJECTOIRE**  
F9 → aucune correction possible → blocage.

**EXPECT**  
overall_status=BLOCKED, A2 impossible.

---

# 5. CAS 5 — RÉGRESSION A2 → A0 (Dérive FS)

**BUT**  
Suppression/déplacement fichier sur DST.

**INPUT**  
Torrent en A2, G: fs_dst=MISSING, mirror=INCOMPLETE.

**TRAJECTOIRE**  
A2-EXIT-G2 → A2→A0.

**EXPECT**  
overall_status=BLOCKED, retour A0.

---

# 6. CAS 6 — RÉGRESSION A2 → A1 (Client UNSAFE)

**BUT**  
Erreur client qBittorrent.

**INPUT**  
D: qb_status=UNSAFE.

**TRAJECTOIRE**  
A2-EXIT-D1 → A1.

**EXPECT**  
A1 atteint, overall_status=BLOCKED/ERROR selon issues.

---

# 7. CAS 7 — A2-CrossSeed → SRC PERDU (fs_src=MISSING)

**BUT**  
Tester la perte de la source dans un Cross-Seed.

**INPUT**  
Torrent en A2-CrossSeed, G: fs_src=MISSING, fs_dst=OK.

**TRAJECTOIRE (corrigée)**  
A2-EXIT-G1 → A2→A0.  

En A0 :  
- Si fs_src continue d’être MISSING, le système reste stable en F5, car C2 est complet mais A2-I5 (source OK) n’est pas satisfaisable.  
- Le retour en A2 n’est possible que si la source redevient OK (montage/hardlink réparé).

**EXPECT**  
overall_status=BLOCKED, stabilisation en A0/F5 tant que fs_src!=OK.

---

# 8. CAS 8 — MAPPING MISSING (E)

**BUT**  
Le fichier JSONL ou mapping Sonarr disparaît.

**INPUT**  
E: mapping_status=MISSING.

**EXPECT**  
A2→A0 via EXIT-E1, overall_status=BLOCKED.

---

# 9. CAS 9 — HF4 (Collision Hash Sévère)

**INPUT**  
HASH: hf_state=HF4.

**EXPECT**  
A2→A0 (si client SAFE) ou A2→A1 (si UNSAFE), overall_status=BLOCKED.

---

# 10. CAS 10 — Test d’Idempotence A2

**BUT**  
Deux runs identiques sans changement environnemental.

**INPUT**  
Torrent en A2, tous blocs identiques entre deux B1.

**EXPECT**  
A2→A2, overall_status=OK, CHANGESET=IDENTICAL (B2-I3).

---

_Fin du document._
