# SYNOMAP_V2_Metier_Overview_AGNOSTIC.md

## 1. Pourquoi ce document existe

### 1.1 Contexte d’origine (setup initial)
Le projet Synomap est né d’un environnement où un **client de téléchargement** opère sur un **support source**, tandis qu’un **support destination** et un **système de gestion multimédia** manipulent les fichiers selon leurs propres règles. Les chemins issus du téléchargement (*chemins canoniques*) diffèrent des chemins réels utilisés par le système multimédia. Cette divergence naturelle complexifie la cohérence des données.

### 1.2 Pourquoi une version agnostique ?
Synomap V2 vise désormais à être **multi‑plateforme**, utilisable dans n’importe quelle topologie (PC/serveur, NAS, cloud monté localement, etc.). Les concepts deviennent universels : source, destination, client de téléchargement, moteur multimédia. Cela permet d’appliquer Synomap à tout environnement, sans dépendance à une solution spécifique.

---

## 2. Vision métier générale
Synomap V2 agit comme un **moteur de cohérence** entre :
- un **support source**,
- un **support destination**,
- un **moteur de gestion multimédia**.

Objectif : garantir l’intégrité, la cohérence et la reconstruisabilité des fichiers.

---

## 3. Les trois axes métier A / B / C

### Axe A — État du téléchargement
- A0 : non finalisé  
- A1 : erreur  
- A2 : finalisé + validé

### Axe B — Résolution du mapping
- B0 : inconnu  
- B1–B3 : résoluble  
- B4 : ambigu

### Axe C — État du support destination
- C0 : vide  
- C1 : partiel  
- C2 : complet  
- C3 : corrompu  
- C4 : collision logique

---

## 4. Les 11 familles métier (F0 → F10)
Exemples clés :

### F0 — aveugle
Aucune action sûre possible (mapping absent).

### F5 — cross‑seed généralisé
Destination complète avant la fin du téléchargement → hashcheck → promotion A2.

### F7 — corruption
Données invalides : réparation obligatoire.

### F9 — collision logique
Données valides mais ne correspondant pas au dataset attendu → aucune écriture.

---

## 5. Les blocs du Checker
Six dimensions évaluées :
- E : mapping  
- G : filesystem  
- ABC : intention du support destination  
- D : état du client de téléchargement  
- H : santé du support source  
- HASH : cohérence des empreintes

Chaque bloc génère des états et des issues métier.

---

## 6. Statut global : overall_status
Priorité stricte : **BLOCKED > ERROR > WARN > OK**

Deux sources de blocage :
1. conditions structurelles,  
2. issues bloquantes.

---

## 7. Le moteur d’exécution (B1 → B4)
Pipeline générique :

- B1 : Diagnostic  
- B2 : Analyse des changements  
- B3 : Propositions d’actions métier  
- B4 : Exécution via adaptateurs

Adaptable à tout client, tout filesystem.

---

## 8. Miroir, chemins, empreintes
- Chemin canonique ≠ chemin réel  
- Priorité : journal multimédia → empreinte de contenu  
- Ajout : état MIRROR_CANDIDATE  
- Création automatique de dossiers et liens forts

---

## 9. Règles de sécurité universelles
- Aucune suppression sans certitude  
- Un seul Source‑of‑Truth à la fois  
- Promotion A2 uniquement si certitude  
- Collision logique = zone rouge

---

## 10. Résumé exécutif
Synomap V2 : moteur de cohérence fichiers/téléchargements/médias.  
Multi‑environnements, sûr, déterministe, auto‑corrigeant.  
Compatible seedbox, serveurs privés, systèmes cloud, clusters multimédia.

---

## 11. Documents techniques de référence
DOC_OV1, Checker Spec, Case Book, A0/A1/A2, GAP‑004, B1/B2/B3/B4, A4 Schema.
