# SYNOMAP – A2 EVALUATION ORDER SPEC v1 (DIGEST)
# Strict assembly from validated specs (E, G, ABC, D, H, HASH, v7, DOC_OV1).
# No new rules, deterministic ordering only.

[GLOBAL_ORDER]
E → G → ABC → D → H → HASH → CHECKER_OUTPUT_v7 → OVERALL_STATUS_DOC_OV1

[PHASE 1 — E_MAPPING]
- Evaluate mapping_status: OK|MISSING|AMBIGUOUS|INCONSISTENT.
- Emit issues MAPPING_* using Issues Table v1.
- Output: state.block_e.mapping_status.

[PHASE 2 — G_FS]
- Evaluate fs_src, fs_dst, mirror using Spec G.
- Emit issues FS_SRC_*, FS_DST_*, MIRROR_* (Issues Table v1).
- Output: state.block_g.fs_src, fs_dst, mirror.

[PHASE 3 — ABC_INTENT]
- Determine abc_state ∈ {A,B,C,NONE} using existing ABC rules.
- Invariants: seedtime-only, S2_SYNO_CENTRIC, C idempotent.
- Output: state.abc_state.

[PHASE 4 — D_QB]
- Execute after E,G,ABC as defined (ordering contract).
- Evaluate qb_status SAFE|UNSAFE, save_path_ok, tags_state.
- Apply D3→D1→D2→D0 priority, R‑ONCE.
- Emit issues QB_*.
- Output: state.block_d.*.

[PHASE 5 — H_SRC]
- Evaluate SRC reliability: h_state ∈ {H0,H1,H2,H3}.
- Emit issues SRC_*.
- H1/H2/H3 = protection mode, block ABC/G/D (no new rules).
- Output: state.block_h.h_state.

[PHASE 6 — HASH_C3_MD5]
- Run MD5 audit with HASH_DB mode HDB1b.
- Scope: SRC + DST + Plex (HSCOPE_EXT).
- Evaluate hash_mode, hf_state HF0..HF4, primary_md5, locations.
- Emit issues HASH_*.
- Output: state.hash_state.*.

[PHASE 7 — CHECKER_OUTPUT_v7]
- Build final record with identity, paths, state(ABC/E/G/D/H/HASH), diagnostic.
- Include all issues from previous phases.
- No extra fields beyond v7 spec.

[PHASE 8 — OVERALL_STATUS_DOC_OV1]
- Inputs: state.* + diagnostic.issues[].
- blocked_by_blocks(state) if:
    H: h_state!=H0
    D: qb_status=UNSAFE OR (save_path_ok=false AND abc∈{B,C})
    E: mapping_status!=OK
    G: fs_src!=OK OR (abc∈{B,C} AND fs_dst!=OK)
       OR (abc∈{B,C} AND mirror=INCOMPLETE)
       OR (abc=C AND mirror=UNKNOWN)
    HASH: hf_state=HF4
- blocked_by_issues: exists issue.blocked_by_code=true.
- Status:
    BLOCKED if blocked_by_blocks or blocked_by_issues
    else ERROR if exists severity=ERROR
    else WARN if exists severity=WARN
    else OK
- Output: diagnostic.overall_status.

[END DIGEST]
