SYNOMAP – A3 CASE BOOK v1 (DIGEST)
=================================

Objet :
A3 fournit un ensemble réduit mais déterministe de cas représentatifs
permettant à une IA ou un moteur d’exécution de vérifier que toutes les
règles ABC, H, D, E, G, HASH et DOC_OV1 sont correctement appliquées.

Format :
Chaque cas se décrit par :
  INPUT  : état minimal des blocs
  EXPECT : overall_status, flags, issues attendues

CAS 1 — ABC = A, tout OK
------------------------
INPUT :
  H: VALID
  ABC: A
  D: qb_status=SEEDING, save_path_ok=TRUE, tags_state=OK
  E: mapping_state=OK
  G: fs_dst=OK, mirror=OK
  HASH: hash_status=OK
EXPECT :
  overall_status = OK

CAS 2 — ABC = B, mapping absent
-------------------------------
INPUT :
  H: VALID
  ABC: B
  D: qb_status=SEEDING, save_path_ok=TRUE
  E: mapping_state=MISMATCH
  G: fs_dst=OK
  HASH: OK
EXPECT :
  overall_status = WARNING
  issue = MAPPING_MISMATCH

CAS 3 — ABC = C, mirror incomplet
---------------------------------
INPUT :
  H: VALID
  ABC: C
  D: qb_status=ACTIVE
  E: mapping_state=OK
  G: mirror=INCOMPLETE
  HASH: OK
EXPECT :
  overall_status = WARNING
  issue = MIRROR_INCOMPLETE

CAS 4 — HASH échec (hf2)
------------------------
INPUT :
  H: VALID
  ABC: quelconque
  D: quelconque
  E: OK
  G: OK
  HASH: hf2=TRUE, hash_status=ERROR
EXPECT :
  overall_status = ERROR

CAS 5 — SRC invalide
--------------------
INPUT :
  H: INVALID
  reste minimal
EXPECT :
  overall_status = BLOCKED

CAS 6 — save_path incorrect
---------------------------
INPUT :
  H: VALID
  ABC: A
  D: save_path_ok=FALSE
  E: OK
  G: OK
  HASH: OK
EXPECT :
  overall_status = WARNING
  issue = SAVE_PATH_INVALID

Cas digest minimal fourni pour validation structurelle.
