SYNOMAP – B1 LOOP EXECUTION MODEL v1 (DIGEST)
============================================

SCOPE
-----
Décrit comment le moteur Synomap exécute UNE PASSE de Checker
("run B1") sur un ensemble de torrents.
Ne définit pas la persistance ni les re-runs (B2).

DEPENDANCES
-----------
- A1 : Checker Spec (blocs ABC, E, G, D, H, HASH)
- A2 : Ordre d’évaluation : E → G → ABC → D → H → HASH → v7 → DOC_OV1
- A3 : Case Book (combinaisons possibles)
- A4 : JSON Schema (torrent_record)
- A1.1_addendum_identity_preconditions
- A1.1_addendum_no_fallback
- GAPS_A_v1.0

ENTITES
-------
INPUT_SET
  Ensemble des "sujets Synomap" à analyser pendant ce run.
  Chaque sujet est identifié au minimum par un identity.* candidat
  (infohash/torrent_id/mapping_key).
  B1 ne spécifie pas comment INPUT_SET est construit.

TORRENT_SUBJECT
  Élément de INPUT_SET, unité de travail de la Loop.
  Pour chaque TORRENT_SUBJECT, B1 produit au plus un torrent_record JSON
  conforme à A4.

OUTPUT_SET
  Ensemble des torrent_record produits pendant ce run.

INVARIANTS
----------
B1-I1 : Le run B1 est purement fonctionnel vis-à-vis de ses entrées :
        pour un INPUT_SET et un environnement A1–A4 identiques,
        OUTPUT_SET est identique (même ordre non garanti).
B1-I2 : Aucun effet de bord sur qB, FS, Sonarr, Radarr, etc.
        (les actions appartiennent à B3).
B1-I3 : Chaque TORRENT_SUBJECT est traité indépendamment des autres
        (pas de dépendance inter-sujets).

SEQUENCE GLOBALE (RUN)
----------------------
B1-RUN-1 : Construire INPUT_SET (hors scope B1).
B1-RUN-2 : Pour chaque TORRENT_SUBJECT ∈ INPUT_SET, exécuter B1-TORRENT.
B1-RUN-3 : Agréger les torrent_record en OUTPUT_SET.
B1-RUN-4 : Remettre OUTPUT_SET au composant suivant (persistant, UI, etc.).

TRAITEMENT D’UN TORRENT_SUBJECT (B1-TORRENT)
-------------------------------------------
B1-TORRENT-1 : Construction d’identity
  - Récupérer les données nécessaires à identity.* selon A4.
  - Appliquer A1.1_addendum_identity_preconditions.
  - Si préconditions violées :
      → Construire un torrent_record minimal :
           * identity.* avec ce qui est disponible,
           * diagnostic.issues += IDENTITY_INVALID (critique),
           * diagnostic.overall_status = BLOCKED (DOC_OV1).
      → Aller à B1-TORRENT-6 (finalisation).

B1-TORRENT-2 : Collecte des entrées de blocs
  - Préparer les entrées pour :
      E : mapping (mapping_key, category, etc.)
      G : vue FS (SRC, DST, mirrors)
      ABC : informations nécessaires à la logique A/B/C
      D : état qB (statut, save_path, tags)
      H : état de la source (fiabilité)
      HASH : infos nécessaires MD5 / DB
  - B1 ne spécifie PAS comment ces infos sont obtenues, seulement
    qu’elles doivent être disponibles avant évaluation.

B1-TORRENT-3 : Evaluation des blocs (ordre A2)
  - EVALUATE_E     → state.block_e.mapping_status, issues_E
  - EVALUATE_G     → state.block_g.*, issues_G
  - EVALUATE_ABC   → state.abc_state, issues_ABC
  - EVALUATE_D     → state.block_d.*, issues_D
  - EVALUATE_H     → state.block_h.h_state, issues_H
  - EVALUATE_HASH  → state.hash_state.*, issues_HASH

  Règles :
    - Chaque bloc est évalué selon A1 + A3 (pas de logique nouvelle).
    - Les fonctions EVALUATE_* ne produisent que :
        * des champs dans state.*
        * des issues spécifiques au bloc.

B1-TORRENT-4 : Construction du record v7
  - Construire un objet conforme à A4 :
      identity   (déjà construit),
      paths      (si applicable à ce sujet),
      state      (abc_state + block_e/g/d/h + hash_state),
      diagnostic :
        * issues = concat(issues_E,G,ABC,D,H,HASH)
        * overall_status = calculé en B1-TORRENT-5

B1-TORRENT-5 : Calcul de overall_status (DOC_OV1)
  - Appliquer strictement DOC_OV1 sur :
      state.* et diagnostic.issues
  - overall_status ∈ { OK, WARN, ERROR, BLOCKED }

B1-TORRENT-6 : Finalisation
  - Ajouter le torrent_record à OUTPUT_SET.
  - Aucune action de correction appliquée (cf. B3).

ERREURS / FAILURE MODES
-----------------------
B1-ERR-INPUT :
  - Si un TORRENT_SUBJECT ne permet pas de construire identity.*
    selon A1.1, produire :
      issue IDENTITY_INVALID (ou équivalent),
      overall_status = BLOCKED.
  - B1 ne “devine” pas un sujet manquant.

B1-ERR-BLOC :
  - Si un bloc E/G/ABC/D/H/HASH ne peut pas être évalué
    (information d’entrée manquante), produire une issue
    de bloc correspondante et laisser DOC_OV1 trancher.

[END DIGEST]
