SYNOMAP – B2 LOOP RUNNER MODEL v1 (DIGEST)
=========================================

SCOPE
-----
Décrit l’exécution temporelle : runs successifs, persistance, diff, convergence.

DEPENDANCES
-----------
A1–A4, A1.1 addenda, GAPS_A_v1.0, B1.

ENTITES
-------
RUN_ID : identifiant unique d’un run.
RUN_RECORD : { run_id, input_set_summary, output_set, metrics }.
STATE_DB : état persistant par torrent_id/infohash.
CHANGESET : IDENTICAL | MODIFIED | ADDED | REMOVED.
LOOP_RUNNER : moteur B2.

INVARIANTS
----------
B2-I1 : Pas d’action (B3 seulement).
B2-I2 : Append-only.
B2-I3 : Convergence = aucun changement entre runs successifs.

SEQUENCE GLOBALE
----------------
B2-RUN-0 : Charger STATE_DB.
B2-RUN-1 : Construire INPUT_SET.
B2-RUN-2 : Exécuter B1 → OUTPUT_SET.
B2-RUN-3 : Diff avec STATE_DB → CHANGESET.
B2-RUN-4 : Persister RUN_RECORD + mise à jour STATE_DB.
B2-RUN-5 : Décider re-run ou STOP.

CHANGESET LOGIC
---------------
IDENTICAL : record égal au précédent.
MODIFIED  : record différent.
ADDED     : nouveau torrent.
REMOVED   : torrent disparu.

PERSISTENCE
-----------
STATE_DB[id] = {
  last_seen_run_id,
  last_record,
  last_overall_status,
  last_state_hash,
  last_changeset
}
RUN_RECORD en runs/<run_id>.json.

SCHEDULING
----------
Re-run si : MODIFIED, ADDED, forced_run, intervalle planifié.

STOP CONDITIONS
---------------
Convergence, Hard Stop, Fail-Safe Stop.

INTERACTION AVEC B3
-------------------
B2 ne lance jamais d’actions. Fournit CHANGESET + historique à B3.

[END DIGEST]
