SYNOMAP – B3 CORRECTION MODEL v1 (DIGEST)
========================================

SCOPE
-----
Décrit les règles permettant d’appliquer des actions correctives sur :
- qBittorrent (tags, pause/resume, force recheck),
- FileSystem (optionnel, si autorisé),
- mapping/mirror workflows,
en se basant EXCLUSIVEMENT sur :
  - OUTPUT_SET de B1,
  - CHANGESET de B2,
  - A1–A4,
  - DOC_OV1,
  - A1.1 addenda Identity.

DEPENDANCES
-----------
- A1 : blocs ABC/E/G/D/H/HASH
- A2 : ordre d’évaluation
- A3 : Case Book (états possibles)
- A4 : JSON Schema (torrent_record)
- B1 : diagnostic
- B2 : changements depuis dernier run
- A1.1 addenda, GAPS_A_v1.0

ENTITES
-------
ACTION_CANDIDATE :
    - cible : torrent_id/infohash
    - type  : RECHECK, FIX_TAGS, PAUSE, RESUME, FIX_SAVE_PATH, ...
    - reason: issue ou état à corriger
    - safe  : bool (True = certain, False = nécessite confirmation)

ACTION_PLAN :
    Ensemble d’actions classées par priorité.

R_ONCE FLAG :
    Empêche de rejouer une action identique tant que l’état n’a pas changé.

INVARIANTS
----------
B3-I1 : B3 ne diagnostique pas → il consomme OUTPUT_SET/CHANGESET.
B3-I2 : Aucune action n’est autorisée si identity_invalid.
B3-I3 : Aucune action n’est autorisée si overall_status = BLOCKED.
B3-I4 : PAUSE/RESUME jamais combinés dans un même plan pour un torrent.
B3-I5 : Aucune action irréversible (suppression FS) dans B3 v1.
B3-I6 : Chaque action doit être justifiée par A1–A4 / A3 (pas d’invention).

SEQUENCE B3
-----------
B3-0 : Entrées = OUTPUT_SET (B1) + CHANGESET (B2).
B3-1 : Filtrer torrents éligibles :
        - identity valide
        - overall_status != BLOCKED
        - changements significatifs (CHANGESET ∈ {ADDED, MODIFIED}).
B3-2 : Générer ACTION_CANDIDATES via règles B3-E/G/D/H/HASH.
B3-3 : Appliquer R_ONCE pour filtrer les répétitions inutiles.
B3-4 : Prioriser les actions.
B3-5 : Retourner ACTION_PLAN à B4 (exécution réelle).

REGLES B3 (PAR BLOC)
====================

RÈGLE E (MAPPING)
-----------------
mapping_status ∈ {MISSING, AMBIGUOUS, INCONSISTENT} :
    → aucune action (problème structurel hors B3).

RÈGLE G (FILESYSTEM)
--------------------
G1) fs_src ∈ {MISSING, UNREADABLE} :
      → aucune action qB (problème externe).
G2) fs_dst = PARTIAL AND abc_state = C AND qb_status = SAFE :
      → ACTION: FORCE_RECHECK (safe=true).
G3) mirror = INCOMPLETE AND abc_state = C :
      → ACTION: MIRROR_CLEANUP (safe=false).

RÈGLE D (QBITTORRENT)
---------------------
D1) qb_status = UNSAFE :
      → ACTION: PAUSE (safe=true).
D2) save_path_ok = FALSE AND abc_state ∈ {B,C} :
      → ACTION: PAUSE + FIX_SAVE_PATH (safe=true).
D3) tags_state = MISMATCH :
      → ACTION: FIX_TAGS (safe=true).
D4) qb_incomplete = TRUE AND fs_dst OK AND mirror OK :
      → ACTION: FORCE_RECHECK (safe=true).

RÈGLE H (SRC)
-------------
h_state ∈ {H1, H2, H3} :
    → aucune action qB (blocage amont, hors périmètre B3).

RÈGLE HASH
----------
HF4 (critique) :
    → aucune action (cas à traiter en dehors de B3 v1).
HF3 (mismatch récupérable) :
    → ACTION: FORCE_RECHECK (safe=true).

PRIORISATION
============
Ordre global appliqué après filtrage R_ONCE :

1. PAUSE (UNSAFE qB ou save_path cassé)
2. FIX_SAVE_PATH
3. FORCE_RECHECK
4. FIX_TAGS
5. MIRROR_CLEANUP (safe=false)
6. Autres actions éventuelles

R_ONCE
======
Si une action de même type, même cible, même reason a déjà été proposée
et que le state.* du torrent n’a pas changé depuis :
    → ne pas reproposer l’action.

SORTIE B3
=========
ACTION_PLAN = {
   "run_id": "<id du run B2>",
   "actions": [
       {
         "torrent_id": "...",
         "type": "PAUSE | FORCE_RECHECK | FIX_TAGS | FIX_SAVE_PATH | MIRROR_CLEANUP",
         "reason": "<issue code ou state>",
         "safe": true/false
       },
       ...
   ]
}

B3 ne les exécute pas : B4 s’en charge.

[END DIGEST]
