SYNOMAP – DOC_OV1 DIGEST – overall_status v1
==============================================

[LEVELS]
overall_status ∈ { "OK", "WARN", "ERROR", "BLOCKED" }
Priorité stricte : BLOCKED > ERROR > WARN > OK.

[INPUTS]
Entrées = state.* + diagnostic.issues[].
- state.* = blocs H, D, E, G, HASH, ABC…
- issues[] = { code, block, severity, blocked_by_code }

[BLOCKED BY BLOCKS]
H_blocked = (h_state != H0)
D_blocked = (qb_status == UNSAFE) OR (save_path_ok == false AND abc_state ∈ {B,C}) OR TAGS_CRITIQUES
E_blocked = (mapping_status != OK)
G_blocked = (fs_src != OK) OR (abc_state ∈ {B,C} AND fs_dst != OK) OR (abc_state ∈ {B,C} AND mirror = INCOMPLETE) OR (abc_state = C AND mirror = UNKNOWN)
HASH_blocked = (hf_state == HF4)

blocked_by_blocks(state) =
  H_blocked OR D_blocked OR E_blocked OR G_blocked OR HASH_blocked

[BLOCKED BY ISSUES]
blocked_by_issues(issues) = EXISTS issue WITH issue.blocked_by_code = true.

[OVERALL_STATUS LOGIC]
overall_status = "OK"

if blocked_by_blocks(state):
    overall_status = "BLOCKED"
elif blocked_by_issues(issues):
    overall_status = "BLOCKED"
elif EXISTS issue WITH severity == "ERROR":
    overall_status = "ERROR"
elif EXISTS issue WITH severity == "WARN":
    overall_status = "WARN"
else:
    overall_status = "OK"

[ISSUES TABLE REFERENCE]
Voir : synomap_issues_table_v1.txt
(Bloc H, D, E, G, HASH : codes, severities, blocked_by_code).

[PROPRIÉTÉS]
- Déterministe : mêmes entrées ⇒ même overall_status.
- Fail-safe : si un bloc est bloquant, BLOCKED même sans issue.
- Extensible : ajout de codes/severities sans changer la structure.
