# synomap_DOC_OV1_metier.txt

```
Synomap – DOC_OV1 – overall_status et table des issues (version 1)
============================================================================

1. Objet du document
--------------------
Ce document métier décrit comment le Checker Synomap produit le champ
« overall_status » pour chaque torrent, et comment il s’appuie pour cela :
- sur les états des blocs H / D / E / G / HASH,
- sur la table des issues (codes, severities, flags BLOCKED).

Il s’adresse au pilote du projet (chef de projet / propriétaire fonctionnel) et
doit permettre de comprendre, sans entrer dans le code, pourquoi un torrent est
en statut OK, WARN, ERROR ou BLOCKED, et où regarder pour corriger.


2. Les quatre niveaux de statut
-------------------------------
Le Checker utilise quatre niveaux, ordonnés de manière stricte :
- BLOCKED  : la loop doit s’arrêter sur ce torrent (problème structurel ou risque fort),
- ERROR    : problème sérieux à corriger, mais la loop peut continuer sur les autres torrents,
- WARN     : anomalie ou limite à surveiller, mais non bloquante,
- OK       : aucun problème détecté par le Checker.

La règle de priorité est :
    BLOCKED > ERROR > WARN > OK

En pratique, cela signifie que :
- si au moins une condition de type BLOCKED est vraie, le statut global est BLOCKED,
- sinon, s’il existe au moins une issue de niveau ERROR, le statut global est ERROR,
- sinon, s’il existe au moins une issue de niveau WARN, le statut global est WARN,
- sinon, il est OK.


3. Les deux sources de blocage
------------------------------
Un torrent passe en BLOCKED à partir de deux couches complémentaires :

1) Les blocs structurels (états H / D / E / G / HASH)
   --------------------------------------------------
   Chaque bloc décrit une dimension critique de la cohérence Synomap :

   - Bloc H : état de la source (SRC)
   - Bloc D : état qBittorrent (SAFE / UNSAFE, save_path, tags)
   - Bloc E : mapping (mapping_entries.txt)
   - Bloc G : système de fichiers SRC / DST + mirrors
   - Bloc HASH : cohérence de la base de hash MD5

   La spécification a défini, bloc par bloc, les conditions de blocage :
   - H_BLOCKED      : h_state ≠ H0 (SRC non entièrement sain),
   - D_BLOCKED      : qB UNSAFE, save_path incohérent en B/C, tags critiques,
   - E_BLOCKED      : mapping_status ≠ OK (MISSING, AMBIGUOUS, INCONSISTENT),
   - G_BLOCKED      : incohérences SRC/DST/mirror selon ABC,
   - HASH_BLOCKED   : hf_state = HF4 (collision / ambiguïté grave dans la DB hash).

   Ces règles sont “structurelles” : même si aucune issue n’était générée,
   elles suffiraient à elles seules à mettre overall_status = BLOCKED.

2) Les issues (codes métier)
   -------------------------
   La table des issues décrit, pour chaque anomalie détectée, un triplet :
   - code     (ex : SRC_MISSING, MAPPING_MISSING, HASH_COLLISION_SEVERE…),
   - block    (H / D / E / G / HASH),
   - severity (INFO / WARN / ERROR),
   plus un flag :
   - blocked_by_code = true / false.

   Quand blocked_by_code = true, l’issue est elle-même bloquante : même si
   l’état brut du bloc était mal analysé, le code d’issue protège la loop et
   force overall_status = BLOCKED.


4. Rôle de overall_status dans la loop
--------------------------------------
Le statut global d’un torrent a trois usages principaux :

1) Pilotage de la loop
   - BLOCKED : la loop ne doit pas tenter d’action automatisée supplémentaire
     sur ce torrent tant que la cause racine n’est pas corrigée.
   - ERROR   : la loop peut continuer sur les autres torrents, mais ce torrent
     nécessite une intervention (script ou manuelle).
   - WARN    : la loop indique une anomalie mineure ou une limite (ex. DB hash
     incomplète), mais la situation n’est pas jugée dangereuse.
   - OK      : le torrent est cohérent avec les règles Synomap connues.

2) Priorisation des corrections
   - La combinaison (overall_status + issues) permet de trier les torrents à
     traiter :
       - d’abord les BLOCKED (situations dangereuses / structurelles),
       - puis les ERROR,
       - ensuite les WARN,
       - enfin ceux en OK pour vérification éventuelle.

3) Support UI / API
   - overall_status devient un indicateur clé dans toute interface d’observation
     ou d’admin Synomap : couleurs, filtres, tableaux de bord,
     endpoints d’API, etc.


5. Résumé des critères de blocage par bloc
------------------------------------------
Les éléments suivants sont considérés comme bloquants dans Synomap v1 :

- Bloc H (SRC)
  - SRC partiel, manquant ou illisible (h_state ≠ H0)
  - Issues : SRC_PARTIAL, SRC_MISSING, SRC_UNREADABLE (ERROR + BLOCKED)

- Bloc D (qBittorrent)
  - qB en état UNSAFE,
  - save_path incohérent en état B ou C,
  - tags critiques incohérents avec l’état ABC.
  - Issues : QB_STATUS_UNSAFE, QB_SAVEPATH_INCOHERENT_BC,
             QB_TAGS_MISMATCH_CRITIQUE (ERROR + BLOCKED)

- Bloc E (mapping)
  - mapping absent,
  - mapping ambigu,
  - mapping incohérent avec la hiérarchie attendue.
  - Issues : MAPPING_MISSING, MAPPING_AMBIGUOUS, MAPPING_INCONSISTENT
    (ERROR + BLOCKED)

- Bloc G (FS & mirrors)
  - SRC partiel, manquant ou illisible,
  - DST incohérent en états B/C,
  - mirror incomplet en B/C, ou inconnu en C.
  - Issues : FS_SRC_*, FS_DST_*_BC, MIRROR_INCOMPLETE_BC, MIRROR_UNKNOWN_C
    (ERROR + BLOCKED)

- Bloc HASH
  - HF4 : collision / ambiguïté grave dans la DB hash.
  - Issue : HASH_COLLISION_SEVERE (ERROR + BLOCKED)


6. Logique finale de calcul (vue métier)
----------------------------------------
Pour chaque torrent, le Checker suit cette logique :

1) Il évalue les blocs H, D, E, G et HASH.
2) Il génère des issues (codes métier) à partir de ce qu’il trouve.
3) Il applique la hiérarchie :

   a) Si au moins un bloc est dans un état bloquant, le torrent est BLOCKED.
   b) Sinon, si au moins une issue est marquée blocked_by_code = true,
      le torrent est aussi BLOCKED.
   c) Sinon, si au moins une issue a severity = ERROR, le torrent est ERROR.
   d) Sinon, si au moins une issue a severity = WARN, le torrent est WARN.
   e) Sinon, le torrent est OK.

Ce mécanisme assure un comportement :
- déterministe,
- lisible,
- extensible (on peut ajouter des codes d’issues sans changer la logique
  globale).


7. Utilisation pratique de overall_status
-----------------------------------------
En production, les principaux usages seront :
- identifier rapidement les torrents en BLOCKED pour investiguer les causes
  les plus graves (SRC cassé, mapping incohérent, qB UNSAFE, etc.),
- suivre la qualité globale du système (nombre de ERROR / WARN),
- mesurer l’impact d’une correction (réduction du nombre de BLOCKED/ERROR),
- préparer des actions d’auto-fix guidées par les issues et la DB HASH.

Ce document doit être lu avec :
- la spec des blocs (ABC, H, D, E, G, HASH),
- la “Synomap – Issues Table v1 (Consolidated)”,
- la spec du “Checker – Output Format” (structure JSON de sortie).

```