# SYNOMAP CHECKER SPEC v1 — DIGEST (A1 COMPLETE)
# Deterministic, zero-guess, zero-creativity, strict assembly.

[BLOCK ORDER]
E → G → ABC → D → H → HASH → CHECKER_OUTPUT (v7) → DOC_OV1

[STATE MODEL]
ABC:
  A = NEW_MAPPED
  B = MIRROR_CREATED_SAVE_ON_DATA
  C = OK_SYNO
  invariants: S2_SYNO_CENTRIC; seedtime-only; C idempotent.

E (mapping):
  states: K(mapping_invalid), E(mapping_ambiguous), F(unknown_category)
  priority: K > E > F
  soft-block: ABC forbidden
  tags: SYNO_ERR_MAP (K/E), SYNO_ERR_CAT (F)

G (FS):
  states: G0(fs_ok), G1(dst_inconsistent), H(src_missing)
  SRC = authority; DST = strict mirror
  rules: never touch SRC; only rebuild DST; no qB API; one rebuild/run.

D (qB):
  states: D0(consistent), D1(save_path_mismatch), D2(tag_mismatch), D3(unsafe)
  unsafe_min: { error, missingFiles, metadataError, ioError,
                stalledUP_with_error, checkingResumeData_blocked, unknown }
  profile_ABC:
    A: expect_save_path=/data ; tags: {}
    B: expect_save_path=/data ; tags: {SYNO}
    C: expect_save_path=/syno ; tags: {SYNO_OK}
  R-ONCE: one correction per torrent per run; no while-loop.

H (SRC orphelins):
  states: H0(ok), H1(partial), H2(absent), H3(unreadable)
  tag: SYNO_ERR_FS ; remove SYNO_OK
  full block of ABC/G/D.

HASH:
  mode: C3 (full audit)
  db: HDB1b (diagnostic + auto-fix candidates)
  halg: MD5 (HALG_MD5)
  scope: HSCOPE_EXT (SRC + DST + Plex)
  states: HF0..HF4
  HF4 = blocking.

[CHECKER_OUTPUT FORMAT — v7]
record:
  identity: torrent_id, infohash, name, category, mapping_key, size
  paths: src_root, dst_root, plex_paths[]
  state:
    abc_state = A|B|C|NONE
    block_e.mapping_status = OK|MISSING|AMBIGUOUS|INCONSISTENT
    block_g.fs_src = OK|MISSING|PARTIAL|UNREADABLE
    block_g.fs_dst = OK|MISSING|PARTIAL|UNREADABLE
    block_g.mirror = COMPLETE|INCOMPLETE|UNKNOWN
    block_d.qb_status = SAFE|UNSAFE
    block_d.save_path_ok = bool
    block_d.tags_state = CONSISTENT|MISMATCH|UNKNOWN
    block_h.h_state = H0|H1|H2|H3
    hash_state.hash_mode = OFF|PARTIAL|FULL
    hash_state.hf_state = HF0..HF4
    hash_state.primary_md5 = string|null
    hash_state.primary_md5_locations.src|dst|plex = PRESENT|ABSENT|UNKNOWN
  diagnostic:
    overall_status = OK|WARN|ERROR|BLOCKED
    issues[] = { code, block, severity, blocked_by_code }
    auto_fix_candidates[] = { type, confidence }

[ISSUES TABLE v1]
Use consolidated list exactly as provided (H/D/E/G/HASH):
  (code, block, severity, blocked_by_code).

[DOC_OV1 — overall_status LOGIC]
levels:
  overall_status ∈ { OK, WARN, ERROR, BLOCKED }
  strict priority: BLOCKED > ERROR > WARN > OK.

blocked_by_blocks(state):
  H_blocked = (h_state != H0)
  D_blocked = (qb_status == UNSAFE)
              OR (save_path_ok == false AND abc_state ∈ {B,C})
              OR TAGS_CRITIQUES
  E_blocked = (mapping_status != OK)
  G_blocked = (fs_src != OK)
              OR (abc_state ∈ {B,C} AND fs_dst != OK)
              OR (abc_state ∈ {B,C} AND mirror = INCOMPLETE)
              OR (abc_state = C AND mirror = UNKNOWN)
  HASH_blocked = (hf_state == HF4)

blocked_by_issues(issues):
  EXISTS issue WITH issue.blocked_by_code = true.

overall_status:
  if blocked_by_blocks(state):
      "BLOCKED"
  elif blocked_by_issues(issues):
      "BLOCKED"
  elif EXISTS issue WITH severity == "ERROR":
      "ERROR"
  elif EXISTS issue WITH severity == "WARN":
      "WARN"
  else:
      "OK"

[PROPERTIES]
- deterministic: same inputs → same output
- fail-safe: any blocking condition forces BLOCKED
- extensible: new issue codes allowed without schema change.

[END DIGEST]
