#!/bin/bash
set -euo pipefail

# === Script : autobrr_push_radarr.sh v1.1 ===
# Objectif : transmettre à Radarr le lien local du .torrent téléchargé par Autobrr
# Intégré dans le flux : Autobrr → Mini Web Server → Radarr → qBittorrent
# Fonctionne aussi en mode autonome (cookie YGG actif)
# Comporte une boucle d’attente dynamique pour éviter les échecs si le torrent n’est pas encore prêt.

# === CONFIG ===
WEB_DIR="/autobrr_web/torrents/radarr"
LOG_FILE="/scripts/autobrr/log/autobrr_push_radarr.log"
RADARR_URL="http://192.168.0.101:7878"
RADARR_KEY="aed5134bcacb46c58d64be4b422dbb37"
COOKIE_FILE="/scripts/autobrr/cookies/cookies.txt"
MAX_WAIT=60
MAX_LOG_SIZE=$((10 * 1024 * 1024))

mkdir -p "$WEB_DIR" "$(dirname "$LOG_FILE")"

# === Fonction de log ===
log() {
  if [[ -f "$LOG_FILE" && $(stat -c%s "$LOG_FILE") -gt $MAX_LOG_SIZE ]]; then
    mv "$LOG_FILE" "${LOG_FILE}.1"
    echo "[$(date '+%F %T')] [INFO] Log rotation" > "$LOG_FILE"
  fi
  echo "[$(date '+%F %T')] $*" | tee -a "$LOG_FILE"
}

# === Arguments ===
TORRENT_URL="$1"
TORRENT_NAME="$(basename "$TORRENT_URL" | cut -d'?' -f1)"
DEST_PATH="$WEB_DIR/$TORRENT_NAME"

log "[INFO] Début du traitement Radarr : $TORRENT_NAME"

# === Étape 1 : Attente dynamique de disponibilité ===
log "[INFO] Vérification disponibilité du torrent..."
for i in $(seq 1 $MAX_WAIT); do
  [[ -f "$DEST_PATH" ]] && break
  sleep 1
done
if [[ ! -f "$DEST_PATH" ]]; then
  log "[ERREUR] Torrent introuvable après $MAX_WAIT s : $DEST_PATH"
  exit 1
fi
log "[OK] Torrent trouvé : $DEST_PATH"

# === Étape 2 : Construction du JSON et envoi à Radarr ===
JSON_PAYLOAD=$(jq -n \
  --arg url "http://192.168.0.101:8990/torrents/radarr/$TORRENT_NAME" \
  '{name: "AutobrrPush", fields: [{name:"torrentUrl", value:$url}]}')

curl -s -X POST "$RADARR_URL/api/v3/command" \
  -H "X-Api-Key: $RADARR_KEY" \
  -H "Content-Type: application/json" \
  -d "$JSON_PAYLOAD" >/dev/null

log "[OK] Notification envoyée à Radarr : $TORRENT_NAME"
exit 0
