#!/bin/bash
set -euo pipefail

# === Script : cleanup_autobrr_torrents.sh v1.1 ===
# Objectif : supprimer les anciens fichiers .torrent pour éviter l’encombrement
# Intégré dans le flux Seedbox Manager pour maintenance automatique
# Programmable via cron (voir README)

# === CONFIG ===
TARGET_DIRS=(
  "/autobrr_web/torrents/sonarr"
  "/autobrr_web/torrents/radarr"
)
LOG_FILE="/scripts/autobrr/log/cleanup_autobrr_torrents.log"
MAX_LOG_SIZE=$((5 * 1024 * 1024))
MAX_AGE_DAYS=7

mkdir -p "$(dirname "$LOG_FILE")"

log() {
  if [[ -f "$LOG_FILE" && $(stat -c%s "$LOG_FILE") -gt $MAX_LOG_SIZE ]]; then
    mv "$LOG_FILE" "${LOG_FILE}.1"
    echo "[$(date '+%F %T')] [INFO] Log rotation" > "$LOG_FILE"
  fi
  echo "[$(date '+%F %T')] $*" | tee -a "$LOG_FILE"
}

log "[INFO] Nettoyage des fichiers .torrent de plus de $MAX_AGE_DAYS jours..."

for dir in "${TARGET_DIRS[@]}"; do
  if [[ -d "$dir" ]]; then
    find "$dir" -type f -name "*.torrent" -mtime +$MAX_AGE_DAYS -print -delete | while read -r file; do
      log "[DEL] $file"
    done
  else
    log "[WARN] Répertoire introuvable : $dir"
  fi
done

log "[OK] Nettoyage terminé."
exit 0
