#!/bin/bash
set -euo pipefail

# === CONFIG ===
BASE_PATH="/srv/dev-disk-by-uuid-167c3d64-0b12-412d-9453-f941e78f8f6e/data"
LOG_FILE="$BASE_PATH/scripts/autobrr/log/fix_autobrr_perms.log"
OWNER="appuser"
GROUP="users"

log() {
  echo "[$(date '+%F %T')] $*" | tee -a "$LOG_FILE"
}

log "=== Vérification et correction des permissions Autobrr ==="

# Dossiers à vérifier
DIRS=(
  "$BASE_PATH/scripts/autobrr/scripts"
  "$BASE_PATH/scripts/autobrr/log"
  "$BASE_PATH/scripts/autobrr/torrent"
  "$BASE_PATH/scripts/autobrr/cookies"
  "$BASE_PATH/autobrr_web/torrents/sonarr"
  "$BASE_PATH/autobrr_web/torrents/radarr"
)

for dir in "${DIRS[@]}"; do
  if [[ -d "$dir" ]]; then
    chown -R "$OWNER:$GROUP" "$dir"
    # Permissions spécifiques selon le type de dossier
    case "$dir" in
      *log|*torrent)
        chmod -R 775 "$dir"
        ;;
      *cookies|*scripts|*sonarr|*radarr)
        chmod -R 755 "$dir"
        ;;
    esac
    # setgid pour héritage du groupe
    find "$dir" -type d -exec chmod g+s {} \;
    log "[OK] $dir corrigé → $OWNER:$GROUP avec permissions adaptées"
  else
    log "[WARN] Dossier manquant : $dir"
  fi
done

log "=== Vérification terminée ==="
