#!/bin/bash
set -euo pipefail

# === CONFIG ===
LOG_DIR="/scripts/autobrr/log"
ARCHIVE_FILE="$LOG_DIR/daily_summary.log"
SONARR_STATS="$LOG_DIR/sonarr_stats.txt"
RADARR_STATS="$LOG_DIR/radarr_stats.txt"
RETENTION_DAYS=30

TODAY=$(date '+%F')

get_count() {
  local FILE="$1"
  if [[ -f "$FILE" ]]; then
    local FILE_DATE
    FILE_DATE=$(head -n1 "$FILE" 2>/dev/null || echo "0")
    if [[ "$FILE_DATE" == "$TODAY" ]]; then
      tail -n1 "$FILE"
    else
      echo "0"
    fi
  else
    echo "0"
  fi
}

SONARR_COUNT=$(get_count "$SONARR_STATS")
RADARR_COUNT=$(get_count "$RADARR_STATS")
TOTAL=$((SONARR_COUNT + RADARR_COUNT))

# --- ARCHIVAGE DU JOUR ---
mkdir -p "$LOG_DIR"
echo "$TODAY | Sonarr: $SONARR_COUNT | Radarr: $RADARR_COUNT | Total: $TOTAL" >> "$ARCHIVE_FILE"

# --- PURGE AUTOMATIQUE DES ANCIENNES LIGNES ---
TMP_FILE=$(mktemp)
CUTOFF_DATE=$(date -d "-${RETENTION_DAYS} days" +%F)

awk -v cutoff="$CUTOFF_DATE" -F'|' '
{
  split($1, d, " ");
  if (d[1] >= cutoff) print $0;
}' "$ARCHIVE_FILE" > "$TMP_FILE"

mv "$TMP_FILE" "$ARCHIVE_FILE"

echo "[$(date '+%F %T')] [OK] Archivage effectué. Anciennes entrées (> ${RETENTION_DAYS}j) supprimées."
