#!/bin/bash
# update_cookie.sh
# - Gère et sauvegarde User-Agent, URL RSS et Cookie
# - Teste le cookie, et si échec, sauvegarde la réponse HTML pour debug

set -euo pipefail

BASE_DIR="/srv/dev-disk-by-uuid-167c3d64-0b12-412d-9453-f941e78f8f6e/data/scripts/autobrr"
COOKIE_DIR="$BASE_DIR/cookies"
LOG_DIR="$BASE_DIR/log"

COOKIE_FILE="$COOKIE_DIR/cookies.txt"
URL_FILE="$COOKIE_DIR/rss_url.txt"
UA_FILE="$COOKIE_DIR/user_agent.txt"
LOG_FILE="$LOG_DIR/update_cookie.log"
DEBUG_FILE="$LOG_DIR/update_cookie_debug.html"

mkdir -p "$COOKIE_DIR" "$LOG_DIR"

DEFAULT_URL="https://www.yggtorrent.top/rss?action=generate&type=cat&id=2145&passkey=C9sGbLkJ6kkG7JGHDM8ME9vhJ81RZdpN"
DEFAULT_UA="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0"

log() { echo "[$(date '+%Y-%m-%d %H:%M:%S')] $*" | tee -a "$LOG_FILE"; }

# Lecture valeurs existantes
RSS_URL="$( [[ -f "$URL_FILE" ]] && cat "$URL_FILE" || echo "" )"
UA_VAL="$( [[ -f "$UA_FILE" ]] && cat "$UA_FILE" || echo "" )"
COOKIE_VAL="$( [[ -f "$COOKIE_FILE" ]] && cat "$COOKIE_FILE" || echo "" )"

# Première config si fichiers absents
if [[ -z "$RSS_URL" || -z "$UA_VAL" ]]; then
  echo "=== Configuration initiale ==="
  read -p "URL RSS (ENTER pour défaut) : " in_url
  RSS_URL="${in_url:-$DEFAULT_URL}"
  read -p "User-Agent (ENTER pour défaut) : " in_ua
  UA_VAL="${in_ua:-$DEFAULT_UA}"

  echo -n "$RSS_URL" > "$URL_FILE"
  echo -n "$UA_VAL"  > "$UA_FILE"
fi

# Demande cookie (toujours mis à jour)
echo
echo "Colle maintenant ton cookie complet (clé=valeur; clé=valeur; ...)"
echo "Puis appuie sur Entrée et Ctrl+D pour valider :"
NEW_COOKIE=$(</dev/stdin)
if [[ -n "$NEW_COOKIE" ]]; then
  echo "$NEW_COOKIE" > "$COOKIE_FILE"
  chmod 600 "$COOKIE_FILE" || true
  COOKIE_VAL="$NEW_COOKIE"
  log "Nouveau cookie sauvegardé."
fi

# Test du cookie
log "Test du cookie sur : $RSS_URL"
HTTP_CODE=$(curl -s -o /tmp/rss_test.html -w "%{http_code}" \
  -b "$COOKIE_FILE" \
  -A "$UA_VAL" \
  -H "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8" \
  -H "Accept-Language: fr-FR,fr;q=0.9" \
  -H "Connection: keep-alive" \
  "$RSS_URL" || echo "000")

if [[ "$HTTP_CODE" == "200" ]]; then
  log "[OK] Cookie valide (HTTP $HTTP_CODE)"
  rm -f "$DEBUG_FILE" 2>/dev/null || true
elif [[ "$HTTP_CODE" == "403" && "$(grep -i 'Just a moment' /tmp/rss_test.html || true)" != "" ]]; then
  log "[INFO] Challenge Cloudflare détecté (HTTP 403)."
  log "→ Le cookie est probablement bon, Autobrr devrait fonctionner."
  mv /tmp/rss_test.html "$DEBUG_FILE"
  log "Page de challenge sauvegardée dans : $DEBUG_FILE"
else
  log "[ERREUR] Cookie invalide ou expiré (HTTP $HTTP_CODE)"
  mv /tmp/rss_test.html "$DEBUG_FILE"
  log "Réponse complète sauvegardée dans : $DEBUG_FILE"
fi