#!/bin/sh
# ============================================================
# Script : autobrr_push_radarr.sh
# Projet : Seedbox Manager – Flux Autobrr → Radarr
# ============================================================
# Objectif :
#   - Appelé automatiquement par Autobrr lorsqu'une release
#     correspond à un filtre Radarr.
#   - Transmet le lien du torrent à Radarr via son API.
#   - Permet d’ajouter le téléchargement à qBittorrent.
#
# Intégration :
#   Commande : /scripts/autobrr/scripts/autobrr_push_radarr.sh
#   Arguments : ['{{ .TorrentUrl }}']
# ============================================================

# --- Variables globales ---
RADARR_URL="http://192.168.0.101:7878"
RADARR_API_KEY="YOUR_RADARR_API_KEY"
TORRENT_URL="$1"
LOG_FILE="/scripts/autobrr/logs/autobrr_radarr_push.log"

# --- Vérification des paramètres ---
if [ -z "$TORRENT_URL" ]; then
    echo "$(date '+%Y-%m-%d %H:%M:%S') [Error] Aucun lien torrent fourni." >> "$LOG_FILE"
    exit 1
fi

# --- Envoi du lien à Radarr ---
RESPONSE=$(curl -s -o /dev/null -w "%{http_code}" \
  -X POST "$RADARR_URL/api/v3/release/push" \
  -H "X-Api-Key: $RADARR_API_KEY" \
  -H "Content-Type: application/json" \
  -d "{\"title\": \"autobrr_push\", \"downloadUrl\": \"$TORRENT_URL\", \"protocol\": \"torrent\"}")

# --- Gestion du résultat ---
if [ "$RESPONSE" = "200" ]; then
    echo "$(date '+%Y-%m-%d %H:%M:%S') [OK] Envoi à Radarr réussi : $TORRENT_URL" >> "$LOG_FILE"
else
    echo "$(date '+%Y-%m-%d %H:%M:%S') [Error] Radarr a renvoyé le code $RESPONSE pour $TORRENT_URL" >> "$LOG_FILE"
fi

exit 0
