#!/bin/sh
# ============================================================
# Script : autobrr_push_sonarr.sh (v4.0)
# Objet  : Quand Autobrr match → publier le .torrent via ton site local vers Sonarr (/api/v3/release/push)
# Appel  : autobrr_push_sonarr.sh "<TorrentUrl>" "<TorrentName>" "<TorrentHash>" "<IndexerName>" "<Size>"
#          (si certains manquent, le script tente des fallbacks)
# ============================================================

# ---- Config Sonarr (adapte si besoin) ----
SONARR_URL="http://192.168.0.101:8989"
SONARR_API_KEY="317e978a981b461f808f8cd4a370ea94"

# ---- Emplacements dans *le conteneur* autobrr ----
# (Chez toi autobrr monte /data/autobrr_web -> /srv/.../data/autobrr_web sur l'hôte)
TORRENT_DIRS="
/data/autobrr_web/torrents/sonarr
/autobrr_web/torrents/sonarr
"
WEB_BASE_URL="http://192.168.0.101:8990/torrents/sonarr"

# ---- Logs ----
LOG_DIR="/scripts/autobrr/log"
LOG_FILE="$LOG_DIR/autobrr_push_sonarr.log"
MAX_LOG_BYTES=$((10*1024*1024))
mkdir -p "$LOG_DIR"
[ -f "$LOG_FILE" ] && sz=$(wc -c < "$LOG_FILE" 2>/dev/null || echo 0) && [ "$sz" -gt "$MAX_LOG_BYTES" ] && mv "$LOG_FILE" "${LOG_FILE}.1"
log(){ printf "%s %s\n" "$(date '+[%Y-%m-%d %H:%M:%S]')" "$*" | tee -a "$LOG_FILE" ; }

# ---- Entrées Autobrr ----
TORRENT_URL_IN="$1"    # URL YGG (pour le log, Sonarr ne l'utilisera pas)
TORRENT_NAME_IN="$2"   # Nom de la release (idéal pour le title parseable)
TORRENT_HASH_IN="$3"   # Hash (sera exploité en v4.1 pour du matching fort)
INDEXER_IN="$4"        # Nom d’indexeur (affichage Sonarr)
SIZE_IN="$5"           # Taille en octets (info à Sonarr, optionnelle)

ISO_DATE="$(date -u +"%Y-%m-%dT%H:%M:%SZ")"

log "========== AUTOBRR → SONARR PUSH v4.0 =========="
log "[ARGS] TorrentUrl   : ${TORRENT_URL_IN:-<vide>}"
log "[ARGS] TorrentName  : ${TORRENT_NAME_IN:-<vide>}"
log "[ARGS] TorrentHash  : ${TORRENT_HASH_IN:-<vide>}"
log "[ARGS] IndexerName  : ${INDEXER_IN:-<vide>}"
log "[ARGS] Size(bytes)  : ${SIZE_IN:-<vide>}"

# ---- Cherche un .torrent récent dans les répertoires connus ----
# (fenêtre 10 min, sinon fallback 24h – on choisit le plus récent)
pick_recent_torrent(){
  # fenêtre 10 min
  for d in $TORRENT_DIRS; do
    [ -d "$d" ] || continue
    find "$d" -maxdepth 1 -type f -name "autobrr-*.torrent" -mmin -10 2>/dev/null
  done | sort -r | head -n 1
}

pick_older_torrent(){
  for d in $TORRENT_DIRS; do
    [ -d "$d" ] || continue
    find "$d" -maxdepth 1 -type f -name "autobrr-*.torrent" -mtime -1 2>/dev/null
  done | sort -r | head -n 1
}

TORRENT_FILE="$(pick_recent_torrent)"
[ -z "$TORRENT_FILE" ] && TORRENT_FILE="$(pick_older_torrent)"

if [ -z "$TORRENT_FILE" ] || [ ! -f "$TORRENT_FILE" ]; then
  log "[ERREUR] Aucun .torrent trouvé (10 min + fallback 24h). Abandon."
  exit 1
fi

BASENAME="$(basename "$TORRENT_FILE")"
PUBLIC_URL="$WEB_BASE_URL/$BASENAME"
SIZE_BYTES="${SIZE_IN:-$(stat -c%s "$TORRENT_FILE" 2>/dev/null || echo 0)}"

log "[INFO] .torrent retenu       : $TORRENT_FILE"
log "[INFO] URL publique (nginx)  : $PUBLIC_URL"
log "[INFO] Taille (octets)       : $SIZE_BYTES"

# ---- Prépare un titre exploitable par Sonarr ----
TITLE="$TORRENT_NAME_IN"
if [ -z "$TITLE" ]; then
  # Fallback simple : nom de fichier sans extension
  TITLE="${BASENAME%.torrent}"
  log "[WARN] Aucun TorrentName fourni, fallback en TITLE='$TITLE'"
fi

# ---- Payload vers Sonarr ----
# On envoie toujours publishDate au format ISO 8601 UTC.
# On renseigne indexer si dispo ; size si dispo.
GUID="autobrr:${TORRENT_HASH_IN:-$TITLE}"

# JSON (simple; hypothèse: pas de guillemets dans $TITLE)
PAYLOAD=$(cat <<JSON
{
  "title": "$TITLE",
  "downloadUrl": "$PUBLIC_URL",
  "protocol": "torrent",
  "publishDate": "$ISO_DATE",
  "size": ${SIZE_BYTES:-0},
  "indexer": "${INDEXER_IN:-AutobrrLocal}",
  "guid": "$GUID",
  "indexerFlags": 0,
  "infoUrl": "http://192.168.0.101:8990/rss/sonarr.xml"
}
JSON
)

log "[DEBUG] Payload Sonarr : $PAYLOAD"

# ---- Envoi et journalisation de la réponse ----
RESP="$(curl -s -S -w "\n%{http_code}" \
  -X POST "$SONARR_URL/api/v3/release/push" \
  -H "X-Api-Key: $SONARR_API_KEY" \
  -H "Content-Type: application/json" \
  -d "$PAYLOAD" )"
HTTP_CODE="$(printf "%s" "$RESP" | tail -n1)"
BODY="$(printf "%s" "$RESP" | sed '$d')"

if [ "$HTTP_CODE" = "200" ] || [ "$HTTP_CODE" = "201" ]; then
  log "[OK] Sonarr a accepté (HTTP $HTTP_CODE). Réponse: $BODY"
  exit 0
else
  log "[ERREUR] Sonarr a refusé (HTTP $HTTP_CODE). Body:"
  log "$BODY"
  # Trace réseau courte en cas d'échec
  curl -v -X POST "$SONARR_URL/api/v3/release/push" \
       -H "X-Api-Key: $SONARR_API_KEY" \
       -H "Content-Type: application/json" \
       -d "$PAYLOAD" \
       -o /dev/null 2>>"$LOG_FILE"
  exit 2
fi
