#!/bin/sh
# ============================================================
# Script : recover_states.sh
# Projet : Seedbox Manager – Maintenance ARR / qBittorrent
# ============================================================
# Objectif :
#   - Synchronise les états de téléchargement entre qBittorrent
#     et les bases locales (state + mapping).
#   - Permet de restaurer les fichiers “state” manquants
#     en cas d’arrêt inopiné ou crash du conteneur.
# ============================================================

# --- Variables globales ---
QBIT_URL="http://192.168.0.101:8090"
QBIT_USER="admin"
QBIT_PASS="YOUR_QBIT_PASSWORD"
STATE_DIR="/scripts/autobrr/state"
LOG_FILE="/scripts/autobrr/logs/recover_states.log"

# --- Connexion à qBittorrent ---
COOKIE=$(curl -si -X POST "$QBIT_URL/api/v2/auth/login" \
  -d "username=$QBIT_USER&password=$QBIT_PASS" | grep -i set-cookie | cut -d' ' -f2)

if [ -z "$COOKIE" ]; then
  echo "$(date '+%Y-%m-%d %H:%M:%S') [Error] Connexion qBittorrent échouée" >> "$LOG_FILE"
  exit 1
else
  echo "$(date '+%Y-%m-%d %H:%M:%S') [Info] Connexion qBittorrent OK" >> "$LOG_FILE"
fi

# --- Récupération des torrents ---
TORRENTS=$(curl -s -b "$COOKIE" "$QBIT_URL/api/v2/torrents/info" | jq -r '.[] | "\(.hash)|\(.name)"')

COUNT=$(echo "$TORRENTS" | wc -l)
echo "$(date '+%Y-%m-%d %H:%M:%S') [Info] Torrents récupérés: $COUNT" >> "$LOG_FILE"

# --- Vérification des fichiers de state ---
mkdir -p "$STATE_DIR"
for LINE in $TORRENTS; do
  HASH=$(echo "$LINE" | cut -d'|' -f1)
  NAME=$(echo "$LINE" | cut -d'|' -f2)
  STATE_FILE="$STATE_DIR/$HASH.state"
  if [ ! -f "$STATE_FILE" ]; then
    echo "$(date '+%Y-%m-%d %H:%M:%S') [Fix] Fichier manquant recréé : $NAME" >> "$LOG_FILE"
    echo "$NAME" > "$STATE_FILE"
  fi
done

echo "$(date '+%Y-%m-%d %H:%M:%S') [Done] Vérification terminée" >> "$LOG_FILE"
exit 0
