#!/bin/sh
# ============================================================
# Script : rss_local_sonarr_feed.sh
# Version : 3.1
# Rôle   : Générer un flux RSS local à partir des .torrent
#          dispos dans /data/autobrr_web/torrents/sonarr
# Servi  : via mini serveur web (ex: http://IP:8990/rss/sonarr.xml)
# ============================================================

WEB_BASE_URL="${WEB_BASE_URL:-http://192.168.0.101:8990}"
WEB_ROOT="${WEB_ROOT:-/data/autobrr_web}"
TORRENTS_DIR="$WEB_ROOT/torrents/sonarr"
RSS_DIR="$WEB_ROOT/rss"
RSS_FILE="$RSS_DIR/sonarr.xml"

LOG_DIR_BASE="/scripts/autobrr"
[ -d "$LOG_DIR_BASE/log" ] && LOG_DIR="$LOG_DIR_BASE/log" || LOG_DIR="$LOG_DIR_BASE/logs"
mkdir -p "$LOG_DIR" "$RSS_DIR"
LOG_FILE="$LOG_DIR/rss_local_sonarr_feed.log"

MAX_ITEMS="${MAX_ITEMS:-200}"   # nombre max d'items dans le RSS
CHANNEL_TITLE="Autobrr Local Feed (Sonarr)"
CHANNEL_LINK="$WEB_BASE_URL/rss/sonarr.xml"
CHANNEL_DESC="Flux local généré à partir des torrents Autobrr"

log(){ printf "%s %s\n" "$(date '+[%Y-%m-%d %H:%M:%S]')" "$*" | tee -a "$LOG_FILE" ; }

escape_xml() {
  # échappe &, <, >, " dans le texte
  printf '%s' "$1" | sed 's/&/\&amp;/g; s/</\&lt;/g; s/>/\&gt;/g; s/"/\&quot;/g'
}

# Liste les .torrent par ordre de modification (récent d'abord)
list_torrents() {
  [ -d "$TORRENTS_DIR" ] || return 0
  # ls -t fonctionne sur busybox; on limite à MAX_ITEMS
  ls -1t "$TORRENTS_DIR"/*.torrent 2>/dev/null | head -n "$MAX_ITEMS"
}

TMP_FILE="$(mktemp)"
PUB_NOW="$(date -u +"%a, %d %b %Y %H:%M:%S +0000")"

{
  echo '<?xml version="1.0" encoding="UTF-8"?>'
  echo '<rss version="2.0">'
  echo '  <channel>'
  echo "    <title>$(escape_xml "$CHANNEL_TITLE")</title>"
  echo "    <link>$(escape_xml "$CHANNEL_LINK")</link>"
  echo "    <description>$(escape_xml "$CHANNEL_DESC")</description>"
  echo "    <lastBuildDate>$PUB_NOW</lastBuildDate>"
  for f in $(list_torrents); do
    [ -f "$f" ] || continue
    name="$(basename "$f")"
    title="${name%.torrent}"
    safe_title="$(escape_xml "$title")"
    url="$WEB_BASE_URL/torrents/sonarr/$name"
    size="$(wc -c < "$f" 2>/dev/null || echo 0)"
    # pubDate : on met la date courante (portable sur busybox)
    echo "    <item>"
    echo "      <title>$safe_title</title>"
    echo "      <link>$(escape_xml "$url")</link>"
    echo "      <guid isPermaLink=\"true\">$(escape_xml "$url")</guid>"
    echo "      <pubDate>$PUB_NOW</pubDate>"
    echo "      <enclosure url=\"$(escape_xml "$url")\" length=\"$size\" type=\"application/x-bittorrent\"/>"
    echo "    </item>"
  done
  echo '  </channel>'
  echo '</rss>'
} > "$TMP_FILE"

mv -f "$TMP_FILE" "$RSS_FILE"
log "[OK] RSS généré : $RSS_FILE"
exit 0
