#!/bin/sh
# ============================================================
# Script : sonarr_periodic_rsssync.sh
# Version : 3.1
# Rôle   : lancer un RssSync global périodique (backup)
# ============================================================
SONARR_URL="${SONARR_URL:-http://192.168.0.101:8989}"
SONARR_API_KEY="${SONARR_API_KEY:-REPLACE_ME}"

LOG_DIR_BASE="/scripts/autobrr"
[ -d "$LOG_DIR_BASE/log" ] && LOG_DIR="$LOG_DIR_BASE/log" || LOG_DIR="$LOG_DIR_BASE/logs"
mkdir -p "$LOG_DIR"
LOG_FILE="$LOG_DIR/sonarr_backup_sync.log"

log(){ printf "%s %s\n" "$(date '+[%Y-%m-%d %H:%M:%S]')" "$*" | tee -a "$LOG_FILE" ; }

log "[INFO] Déclenchement RssSync global (backup périodique)"
curl -s -X POST "$SONARR_URL/api/v3/command" \
  -H "X-Api-Key: $SONARR_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"name":"RssSync"}' | tee -a "$LOG_FILE"
echo "" | tee -a "$LOG_FILE"
