#!/bin/bash
# ============================================================
# Script : test_sonarr_push_debug.sh
# Objectif : Diagnostiquer l’API Sonarr /api/v3/release/push
# ============================================================

SONARR_URL="http://192.168.0.101:8989"
SONARR_API_KEY="317e978a981b461f808f8cd4a370ea94"
TEST_TORRENT_URL="http://192.168.0.101:8990/torrents/sonarr/autobrr-1213996255.torrent"

LOG_FILE="/scripts/autobrr/log/test_sonarr_push_debug.log"
mkdir -p "$(dirname "$LOG_FILE")"
echo "==============================" | tee "$LOG_FILE"
echo "[INFO] Démarrage diagnostic Sonarr $(date)" | tee -a "$LOG_FILE"

# Vérifie connectivité basique
echo "[STEP] Test de connexion Sonarr..." | tee -a "$LOG_FILE"
curl -v --max-time 5 "$SONARR_URL/api/v3/system/status" \
  -H "X-Api-Key: $SONARR_API_KEY" -s -o /tmp/sonarr_status.json
if [ $? -ne 0 ]; then
  echo "[ERROR] Impossible de contacter Sonarr à $SONARR_URL" | tee -a "$LOG_FILE"
  exit 1
fi
jq . /tmp/sonarr_status.json 2>/dev/null | tee -a "$LOG_FILE"

# Génère un payload volontairement complet (tous champs possibles)
PUBLISH_DATE="$(date -u +"%Y-%m-%dT%H:%M:%SZ")"
PAYLOAD=$(cat <<JSON
{
  "title": "DebugPush",
  "downloadUrl": "$TEST_TORRENT_URL",
  "protocol": "torrent",
  "publishDate": "$PUBLISH_DATE",
  "size": 1048576,
  "indexer": "AutobrrLocal",
  "infoUrl": "http://192.168.0.101:8990/rss/sonarr.xml",
  "guid": "debug-$(date +%s)",
  "indexerFlags": 0
}
JSON
)

echo "[STEP] Payload JSON à envoyer :" | tee -a "$LOG_FILE"
echo "$PAYLOAD" | tee -a "$LOG_FILE"

# Envoi vers Sonarr en mode ultra verbeux
echo "[STEP] Envoi vers Sonarr /api/v3/release/push ..." | tee -a "$LOG_FILE"
HTTP_RESPONSE=$(mktemp)
HTTP_CODE=$(curl -v -w "%{http_code}" -s \
  -X POST "$SONARR_URL/api/v3/release/push" \
  -H "X-Api-Key: $SONARR_API_KEY" \
  -H "Content-Type: application/json" \
  -d "$PAYLOAD" -o "$HTTP_RESPONSE")

echo "[INFO] Code HTTP : $HTTP_CODE" | tee -a "$LOG_FILE"
echo "[INFO] Corps de la réponse :" | tee -a "$LOG_FILE"
cat "$HTTP_RESPONSE" | tee -a "$LOG_FILE"
rm -f "$HTTP_RESPONSE"

echo "[STEP] Fin du diagnostic. Vérifie le fichier log complet :" | tee -a "$LOG_FILE"
echo "       $LOG_FILE"
