#!/bin/bash
# ============================================================
# Script : update_radarr_feed.sh
# Version : 1.3 (corrigée pour OMV + Docker Autobrr-Web)
# Projet : Seedbox Manager – Flux RSS local Radarr
# ============================================================
# Fonction :
#   Génère / met à jour le flux RSS compatible Torznab
#   à partir des fichiers .torrent déposés par Autobrr
#   dans /data/autobrr_web/torrents/radarr.
#   Le flux final est écrit dans /data/autobrr_web/rss/radarr.xml
# ============================================================

# --- Paramètres globaux ---
RSS_DIR="/data/autobrr_web/rss"
TORRENT_DIR="/data/autobrr_web/torrents/radarr"
RSS_FILE="${RSS_DIR}/radarr.xml"
WEB_BASE_URL="http://192.168.0.101:8990/torrents/radarr"
LOG_DIR="/scripts/autobrr/logs"
LOG_FILE="${LOG_DIR}/update_radarr_feed.log"
MAX_LOG_BYTES=$((10 * 1024 * 1024))

# --- Initialisation ---
mkdir -p "$RSS_DIR" "$LOG_DIR"
[ -f "$LOG_FILE" ] && [ "$(wc -c < "$LOG_FILE")" -gt "$MAX_LOG_BYTES" ] && mv "$LOG_FILE" "${LOG_FILE}.1"

log() { echo "$(date '+[%Y-%m-%d %H:%M:%S]') $*" | tee -a "$LOG_FILE" ; }

# --- Génération du flux RSS ---
log "[INFO] Génération du flux RSS Radarr..."
{
  echo '<?xml version="1.0" encoding="UTF-8"?>'
  echo '<rss xmlns:torznab="http://torznab.com/schemas/2015/feed" version="2.0">'
  echo '  <channel>'
  echo '    <title>Autobrr Local Feed</title>'
  echo "    <link>http://192.168.0.101:8990/rss/radarr.xml</link>"
  echo '    <description>Flux RSS local compatible Torznab pour Radarr</description>'
  echo '    <language>fr-fr</language>'
  echo ''
  
  # Boucle sur les .torrent
  find "$TORRENT_DIR" -type f -name "*.torrent" -printf "%f\n" | sort | while read -r FILE; do
    SIZE=$(stat -c%s "$TORRENT_DIR/$FILE" 2>/dev/null || echo 0)
    PUBDATE=$(date -r "$TORRENT_DIR/$FILE" -R 2>/dev/null || date -R)
    echo "    <item>"
    echo "      <title>${FILE%.torrent}</title>"
    echo "      <guid isPermaLink=\"false\">${FILE%.torrent}</guid>"
    echo "      <link>${WEB_BASE_URL}/${FILE}</link>"
    echo "      <pubDate>${PUBDATE}</pubDate>"
    echo "      <size>${SIZE}</size>"
    echo "      <category>5040</category>"
    echo "      <torznab:attr name=\"category\" value=\"5040\"/>"
    echo "      <torznab:attr name=\"size\" value=\"${SIZE}\"/>"
    echo "      <enclosure url=\"${WEB_BASE_URL}/${FILE}\" length=\"${SIZE}\" type=\"application/x-bittorrent\"/>"
    echo "    </item>"
    echo ""
  done

  echo '  </channel>'
  echo '</rss>'
} > "$RSS_FILE"

# --- Permissions et logs ---
chmod 664 "$RSS_FILE"
chown root:users "$RSS_FILE"

log "[OK] Flux RSS Radarr mis à jour : $RSS_FILE"
echo "[OK] Script update_radarr_feed.sh installé et permissions modifiées."
