#!/bin/bash
set -euo pipefail
LOG="/scripts/log/radarr_postprocess.log"
MAP="/scripts/mapping_entries.txt"
STATE_DIR="/scripts/state"
mkdir -p "$(dirname "$LOG")" "$STATE_DIR"
touch "$LOG" "$MAP"
ts(){ date '+%F %T'; }

EVT="${radarr_eventtype:-}"
NEW="${radarr_moviefile_path:-}"
OLD="${radarr_moviefile_sourcepath:-}"
ISUP="${radarr_isupgrade:-false}"

echo "$(ts) [Start] Radarr event=$EVT" >> "$LOG"

# Cas "Test"
if [[ "$EVT" == "Test" ]]; then
  echo "$(ts) [Info] Test event, sortie immédiate." >> "$LOG"
  exit 0
fi

# Vérif chemins
if [[ -z "$OLD" || -z "$NEW" ]]; then
  echo "$(ts) [Warn] OLD ou NEW vide → skip" >> "$LOG"
  exit 0
fi

# Mapping
echo "RADARR|$OLD|$NEW" >> "$MAP"

# State filename (basé sur basename de OLD, nettoyé)
base=$(basename "$OLD" | tr ' "\'()' '_____')
STATE="$STATE_DIR/${base}.state"

ADDED=$(date +%s)
UPG=0; [[ "${EVT,,}" == *upgrade* || "${ISUP,,}" == "true" ]] && UPG=1

{
  echo "category=RADARR"
  echo "added=$ADDED"
  echo "upgrade=$UPG"
  echo "old_path=$OLD"
  echo "new_path=$NEW"
} > "$STATE"

echo "$(ts) [State] $STATE créé (upgrade=$UPG)" >> "$LOG"
echo "$(ts) [Done] Radarr" >> "$LOG"
