#!/bin/sh
# Usage: sh synomap_cleanup_omv_only_v1.0.sh [--write] <mini_or_full_plan.txt>
# Conditions pour supprimer des doublons côté OMV :
#  1) SRC et DST (issus du plan) sont hardlinkés (même device+inode, nlinks>=2) — sur /syno
#  2) qBittorrent (si env dispo) : save_path commence par /syno ET progress=100%
# Supprime uniquement des chemins "OMV-ish" connus :
#  - <OMV_DATA>/torrents/completed/<cat>/<basename>
#  - /srv/remotemount/syno_remote_smb/media/torrents/completed/<cat>/<basename>
#  - /srv/remotemount/syno_remote_nfs/media/torrents/completed/<cat>/<basename>
set -eu
WRITE=0
if [ "${1:-}" = "--write" ]; then WRITE=1; shift; fi
if [ $# -lt 1 ]; then echo "Usage: $0 [--write] <plan.txt>" >&2; exit 1; fi
PLAN=$1
[ -f "$PLAN" ] || { echo "Plan not found: $PLAN" >&2; exit 1; }

OMV_DATA="${OMV_DATA:-/srv/dev-disk-by-uuid-167c3d64-0b12-412d-9453-f941e78f8f6e/data}"
CAND_ROOTS="$OMV_DATA/torrents/completed /srv/remotemount/syno_remote_smb/media/torrents/completed /srv/remotemount/syno_remote_nfs/media/torrents/completed"

# qB credentials optionnels
. /etc/synomap/synomap.env 2>/dev/null || true
tmp="$(mktemp)"; trap 'rm -f "$tmp"' EXIT INT TERM

# Paires (header+plan) → tmp
awk '
  /^[0-9a-f]{40}[ \t]/ {hdr=$0; bad=(index($0,"SKIP:")||index($0,"[NOSTAT]")); next}
  /^[ \t]*plan:[ \t]*ln[ \t]/ { if (hdr!="" && !bad) { print hdr; print; hdr=""; } }
' "$PLAN" > "$tmp"

items=0
COOKIE=""
if [ -n "${QB_URL:-}" ] && [ -n "${QB_USER:-}" ] && [ -n "${QB_PASS:-}" ]; then
  COOKIE="$(mktemp)"; trap 'rm -f "$tmp" "$COOKIE"' EXIT INT TERM
  curl -sS -c "$COOKIE" --data-urlencode username="$QB_USER" --data-urlencode password="$QB_PASS" "$QB_URL/api/v2/auth/login" >/dev/null || true
fi

prev=""
while IFS= read -r line; do
  case "$line" in
    [0-9a-f][0-9a-f]*)
      H=$(printf "%s" "$line" | cut -c1-40)
      DEST_DIR=$(printf "%s" "$line" | sed -n "s/.*dest_dir=\([^ ]*\).*/\1/p")
      prev=header
      ;;
    "  "*) # plan: ln ...
      [ "$prev" = "header" ] || continue
      prev=""
      SRC=$(printf "%s\n" "$line" | sed -n "s/^ *plan: ln '\(.*\)' -> '.*'/\1/p")
      DST=$(printf "%s\n" "$line" | sed -n "s/^ *plan: ln '.*' -> '\(.*\)'/\1/p")
      [ -n "$SRC" ] && [ -n "$DST" ] || { echo "[SKIP] parse failure for $H"; continue; }

      info1=$(stat -c "%d %i %h" "$SRC" 2>/dev/null || true)
      info2=$(stat -c "%d %i %h" "$DST" 2>/dev/null || true)
      [ -n "$info1" ] && [ -n "$info2" ] || { echo "[SKIP] stat failed for $H"; continue; }
      set -- $info1; d1=$1; i1=$2; h1=$3
      set -- $info2; d2=$1; i2=$2; h2=$3
      if [ "$d1" != "$d2" ] || [ "$i1" != "$i2" ] || [ "$h1" -lt 2 ]; then
        echo "[SKIP] hardlink check failed for $H"; continue
      fi

      if [ -n "$COOKIE" ]; then
        save=$(curl -sS -b "$COOKIE" "$QB_URL/api/v2/torrents/info?hashes=$H" | jq -r '.[0].save_path' 2>/dev/null || true)
        prog=$(curl -sS -b "$COOKIE" "$QB_URL/api/v2/torrents/info?hashes=$H" | jq -r '.[0].progress' 2>/dev/null || true)
        case "$save" in /syno/*) : ;; *) echo "[SKIP] qB save_path not /syno for $H"; continue;; esac
        case "$prog" in 1|1.0|1.00|1.000000*) : ;; *) echo "[SKIP] qB progress<100% for $H"; continue;; esac
      fi

      cat=$(basename "$DEST_DIR")
      base=$(basename "$DST")
      for root in $CAND_ROOTS; do
        cand="$root/$cat/$base"
        if [ -e "$cand" ]; then
          if [ "$WRITE" -eq 1 ]; then
            echo "rm -- '$cand'"
            rm -f -- "$cand"
          else
            echo "rm -- '$cand'"
          fi
        fi
      done
      items=$((items+1))
      ;;
  esac
done < "$tmp"

[ -n "$COOKIE" ] && rm -f "$COOKIE" || true
[ "$WRITE" -eq 1 ] && echo "Done (cleanup OMV-only, WRITE, items=$items)" || echo "Done (cleanup OMV-only, PREVIEW, items=$items)"
