#!/bin/sh
# Usage: sh synomap_extract_one_v1.0.sh <plan.txt> <hash> [out.txt]
set -eu
if [ $# -lt 2 ]; then
  echo "Usage: $0 <plan.txt> <hash> [out.txt]" >&2
  exit 1
fi
PLAN=$1
H=$2
OUT=${3:-/dev/stdout}
awk -v H="$H" '
  $1==H { print; in=1; next }
  in && /^[ \t]*plan:[ \t]*ln[ \t]/ { print; exit }
' "$PLAN" > "$OUT"
[ -s "$OUT" ] || { echo "[WARN] hash not found or plan line missing: $H" >&2; exit 2; }
