#!/bin/sh
# Usage: sh synomap_miniplan_pick_v1.0.sh <plan.txt> <mini_out.txt> [count]
set -eu
if [ $# -lt 2 ]; then
  echo "Usage: $0 <plan.txt> <mini_out.txt> [count]" >&2
  exit 1
fi
PLAN=$1
OUT=$2
COUNT=${3:-3}
tmp="$(mktemp)"; trap 'rm -f "$tmp"' EXIT INT TERM
awk -v N="$COUNT" '
  /^[0-9a-f]{40}[ \t]/ {hdr=$0; bad=(index($0,"SKIP:")||index($0,"[NOSTAT]")); next}
  /^[ \t]*plan:[ \t]*ln[ \t]/ { if (hdr!="" && !bad) { print hdr; print; hdr=""; n++; if (n>=N) exit } }
' "$PLAN" > "$tmp"
cat "$tmp" > "$OUT"
echo "mini-plan -> $OUT ($(wc -l < "$OUT") lines)"
