\
#!/bin/sh
# synomap_one_apply_v1.1.2.sh
# Purpose: apply for a single hash by extracting its header + plan lines
set -eu
if [ "$#" -lt 2 ]; then
  echo "Usage: $0 HASH /path/to/plan.txt [--write]" >&2
  exit 1
fi
H="$1"
PLAN="$2"
WRITE="${3:-}"
TMP="$(mktemp)"
trap 'rm -f "$TMP" 2>/dev/null || true' EXIT INT TERM

awk -v H="$H" '
  $1==H { print; inside=1; next }
  inside && /^[[:space:]]*plan:[[:space:]]*ln[[:space:]]/ { print; exit }
' "$PLAN" > "$TMP"

SCRIPT_DIR="$(dirname "$0")"
APPLY="$SCRIPT_DIR/synomap_apply_from_plan_v1.2.4.sh"
[ -x "$APPLY" ] || { echo "Missing $APPLY" >&2; exit 1; }
if [ "$WRITE" = "--write" ]; then
  "$APPLY" --write "$TMP"
else
  "$APPLY" "$TMP"
fi
