\
#!/bin/sh
# synomap_orphans_cleanup_v1.0.sh
# Purpose: List potential OMV orphans after migration (NO DELETE, LIST ONLY).
# Strategy: for hashes given on stdin or via plan file, if qB save_path starts with /syno/,
#           check for same basename under a provided OMV root and report.
set -eu

OMV_ROOT="${1:-/srv/dev-disk-by-uuid-167c3d64-0b12-412d-9453-f941e78f8f6e}"

[ -f /etc/synomap/synomap.env ] && . /etc/synomap/synomap.env || true
: "${QB_URL:?QB_URL not set}"
: "${QB_USER:?QB_USER not set}"
: "${QB_PASS:?QB_PASS not set}"

COOKIE="$(mktemp)"
trap 'rm -f "$COOKIE" 2>/dev/null || true' EXIT INT TERM
login_resp="$(curl -sS -c "$COOKIE" -d "username=${QB_USER}&password=${QB_PASS}" "$QB_URL/api/v2/auth/login" || true)"
case "$login_resp" in *Ok.*) : ;; *) echo "[ERROR] qB login failed (got: ${login_resp:-<empty>})" >&2; exit 1;; esac

# Read hashes from stdin
TMP="$(mktemp)"
cat > "$TMP"

while read -r H; do
  [ -n "${H:-}" ] || continue
  info="$(curl -sS -b "$COOKIE" "$QB_URL/api/v2/torrents/info?hashes=$H")"
  save_path="$(printf "%s" "$info" | jq -r '.[0].save_path // ""' 2>/dev/null || echo "")"
  content_path="$(printf "%s" "$info" | jq -r '.[0].content_path // ""' 2>/dev/null || echo "")"
  base="$(basename "$content_path")"
  if [ -n "$save_path" ] && [ "${save_path#/syno/}" != "$save_path" ]; then
    cand="$(find "$OMV_ROOT" -type f -name "$base" -print -quit 2>/dev/null || true)"
    if [ -n "$cand" ]; then
      printf "ORPHAN? hash=%s  save_path=%s  base=%s  omv=%s\n" "$H" "$save_path" "$base" "$cand"
    fi
  fi
done < "$TMP"
